/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ShippingOption {
    SECOND_DAY("SECOND_DAY"),
    NEXT_DAY("NEXT_DAY"),
    EXPRESS("EXPRESS"),
    STANDARD("STANDARD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ShippingOption> VALUE_MAP;
    private final String value;

    private ShippingOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ShippingOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ShippingOption> knownValues() {
        EnumSet<ShippingOption> knownValues = EnumSet.allOf(ShippingOption.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ShippingOption.class, ShippingOption::toString);
    }
}

