/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.VmManagerType;
import software.amazon.awssdk.services.sms.model.VmServerAddress;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VmServer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VmServer> {
    private static final SdkField<VmServerAddress> VM_SERVER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vmServerAddress").getter(VmServer.getter(VmServer::vmServerAddress)).setter(VmServer.setter(Builder::vmServerAddress)).constructor(VmServerAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmServerAddress").build()}).build();
    private static final SdkField<String> VM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vmName").getter(VmServer.getter(VmServer::vmName)).setter(VmServer.setter(Builder::vmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmName").build()}).build();
    private static final SdkField<String> VM_MANAGER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vmManagerName").getter(VmServer.getter(VmServer::vmManagerName)).setter(VmServer.setter(Builder::vmManagerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmManagerName").build()}).build();
    private static final SdkField<String> VM_MANAGER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vmManagerType").getter(VmServer.getter(VmServer::vmManagerTypeAsString)).setter(VmServer.setter(Builder::vmManagerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmManagerType").build()}).build();
    private static final SdkField<String> VM_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vmPath").getter(VmServer.getter(VmServer::vmPath)).setter(VmServer.setter(Builder::vmPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VM_SERVER_ADDRESS_FIELD, VM_NAME_FIELD, VM_MANAGER_NAME_FIELD, VM_MANAGER_TYPE_FIELD, VM_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VmServer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final VmServerAddress vmServerAddress;
    private final String vmName;
    private final String vmManagerName;
    private final String vmManagerType;
    private final String vmPath;

    private VmServer(BuilderImpl builder) {
        this.vmServerAddress = builder.vmServerAddress;
        this.vmName = builder.vmName;
        this.vmManagerName = builder.vmManagerName;
        this.vmManagerType = builder.vmManagerType;
        this.vmPath = builder.vmPath;
    }

    public final VmServerAddress vmServerAddress() {
        return this.vmServerAddress;
    }

    public final String vmName() {
        return this.vmName;
    }

    public final String vmManagerName() {
        return this.vmManagerName;
    }

    public final VmManagerType vmManagerType() {
        return VmManagerType.fromValue(this.vmManagerType);
    }

    public final String vmManagerTypeAsString() {
        return this.vmManagerType;
    }

    public final String vmPath() {
        return this.vmPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vmServerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmManagerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmManagerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VmServer)) {
            return false;
        }
        VmServer other = (VmServer)obj;
        return Objects.equals(this.vmServerAddress(), other.vmServerAddress()) && Objects.equals(this.vmName(), other.vmName()) && Objects.equals(this.vmManagerName(), other.vmManagerName()) && Objects.equals(this.vmManagerTypeAsString(), other.vmManagerTypeAsString()) && Objects.equals(this.vmPath(), other.vmPath());
    }

    public final String toString() {
        return ToString.builder((String)"VmServer").add("VmServerAddress", (Object)this.vmServerAddress()).add("VmName", (Object)this.vmName()).add("VmManagerName", (Object)this.vmManagerName()).add("VmManagerType", (Object)this.vmManagerTypeAsString()).add("VmPath", (Object)this.vmPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vmServerAddress": {
                return Optional.ofNullable(clazz.cast(this.vmServerAddress()));
            }
            case "vmName": {
                return Optional.ofNullable(clazz.cast(this.vmName()));
            }
            case "vmManagerName": {
                return Optional.ofNullable(clazz.cast(this.vmManagerName()));
            }
            case "vmManagerType": {
                return Optional.ofNullable(clazz.cast(this.vmManagerTypeAsString()));
            }
            case "vmPath": {
                return Optional.ofNullable(clazz.cast(this.vmPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vmServerAddress", VM_SERVER_ADDRESS_FIELD);
        map.put("vmName", VM_NAME_FIELD);
        map.put("vmManagerName", VM_MANAGER_NAME_FIELD);
        map.put("vmManagerType", VM_MANAGER_TYPE_FIELD);
        map.put("vmPath", VM_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VmServer, T> g) {
        return obj -> g.apply((VmServer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VmServerAddress vmServerAddress;
        private String vmName;
        private String vmManagerName;
        private String vmManagerType;
        private String vmPath;

        private BuilderImpl() {
        }

        private BuilderImpl(VmServer model) {
            this.vmServerAddress(model.vmServerAddress);
            this.vmName(model.vmName);
            this.vmManagerName(model.vmManagerName);
            this.vmManagerType(model.vmManagerType);
            this.vmPath(model.vmPath);
        }

        public final VmServerAddress.Builder getVmServerAddress() {
            return this.vmServerAddress != null ? this.vmServerAddress.toBuilder() : null;
        }

        public final void setVmServerAddress(VmServerAddress.BuilderImpl vmServerAddress) {
            this.vmServerAddress = vmServerAddress != null ? vmServerAddress.build() : null;
        }

        @Override
        public final Builder vmServerAddress(VmServerAddress vmServerAddress) {
            this.vmServerAddress = vmServerAddress;
            return this;
        }

        public final String getVmName() {
            return this.vmName;
        }

        public final void setVmName(String vmName) {
            this.vmName = vmName;
        }

        @Override
        public final Builder vmName(String vmName) {
            this.vmName = vmName;
            return this;
        }

        public final String getVmManagerName() {
            return this.vmManagerName;
        }

        public final void setVmManagerName(String vmManagerName) {
            this.vmManagerName = vmManagerName;
        }

        @Override
        public final Builder vmManagerName(String vmManagerName) {
            this.vmManagerName = vmManagerName;
            return this;
        }

        public final String getVmManagerType() {
            return this.vmManagerType;
        }

        public final void setVmManagerType(String vmManagerType) {
            this.vmManagerType = vmManagerType;
        }

        @Override
        public final Builder vmManagerType(String vmManagerType) {
            this.vmManagerType = vmManagerType;
            return this;
        }

        @Override
        public final Builder vmManagerType(VmManagerType vmManagerType) {
            this.vmManagerType(vmManagerType == null ? null : vmManagerType.toString());
            return this;
        }

        public final String getVmPath() {
            return this.vmPath;
        }

        public final void setVmPath(String vmPath) {
            this.vmPath = vmPath;
        }

        @Override
        public final Builder vmPath(String vmPath) {
            this.vmPath = vmPath;
            return this;
        }

        public VmServer build() {
            return new VmServer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VmServer> {
        public Builder vmServerAddress(VmServerAddress var1);

        default public Builder vmServerAddress(Consumer<VmServerAddress.Builder> vmServerAddress) {
            return this.vmServerAddress((VmServerAddress)((VmServerAddress.Builder)VmServerAddress.builder().applyMutation(vmServerAddress)).build());
        }

        public Builder vmName(String var1);

        public Builder vmManagerName(String var1);

        public Builder vmManagerType(String var1);

        public Builder vmManagerType(VmManagerType var1);

        public Builder vmPath(String var1);
    }
}

