/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sms.SmsAsyncClient;
import software.amazon.awssdk.services.sms.internal.UserAgentUtils;
import software.amazon.awssdk.services.sms.model.GetServersRequest;
import software.amazon.awssdk.services.sms.model.GetServersResponse;
import software.amazon.awssdk.services.sms.model.Server;

public class GetServersPublisher
implements SdkPublisher<GetServersResponse> {
    private final SmsAsyncClient client;
    private final GetServersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetServersPublisher(SmsAsyncClient client, GetServersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetServersPublisher(SmsAsyncClient client, GetServersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetServersResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetServersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Server> serverList() {
        Function<GetServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.serverList() != null) {
                return response.serverList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetServersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetServersResponseFetcher
    implements AsyncPageFetcher<GetServersResponse> {
        private GetServersResponseFetcher() {
        }

        public boolean hasNextPage(GetServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetServersResponse> nextPage(GetServersResponse previousPage) {
            if (previousPage == null) {
                return GetServersPublisher.this.client.getServers(GetServersPublisher.this.firstRequest);
            }
            return GetServersPublisher.this.client.getServers((GetServersRequest)((Object)GetServersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

