/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sms.DefaultSmsBaseClientBuilder;
import software.amazon.awssdk.services.sms.DefaultSmsClient;
import software.amazon.awssdk.services.sms.SmsClient;
import software.amazon.awssdk.services.sms.SmsClientBuilder;
import software.amazon.awssdk.services.sms.SmsServiceClientConfiguration;
import software.amazon.awssdk.services.sms.endpoints.SmsEndpointProvider;

@SdkInternalApi
final class DefaultSmsClientBuilder
extends DefaultSmsBaseClientBuilder<SmsClientBuilder, SmsClient>
implements SmsClientBuilder {
    DefaultSmsClientBuilder() {
    }

    @Override
    public DefaultSmsClientBuilder endpointProvider(SmsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SmsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSmsClientBuilder.validateClientOptions(clientConfiguration);
        SmsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSmsClient client = new DefaultSmsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SmsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SmsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

