/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AttackLayer {
    NETWORK("NETWORK"),
    APPLICATION("APPLICATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AttackLayer(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AttackLayer fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AttackLayer.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AttackLayer> knownValues() {
        return Stream.of(AttackLayer.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

