/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.shield.model.ShieldRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteProtectionRequest
extends ShieldRequest
implements ToCopyableBuilder<Builder, DeleteProtectionRequest> {
    private static final SdkField<String> PROTECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteProtectionRequest.getter(DeleteProtectionRequest::protectionId)).setter(DeleteProtectionRequest.setter(Builder::protectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_ID_FIELD));
    private final String protectionId;

    private DeleteProtectionRequest(BuilderImpl builder) {
        super(builder);
        this.protectionId = builder.protectionId;
    }

    public String protectionId() {
        return this.protectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protectionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProtectionRequest)) {
            return false;
        }
        DeleteProtectionRequest other = (DeleteProtectionRequest)((Object)obj);
        return Objects.equals(this.protectionId(), other.protectionId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteProtectionRequest").add("ProtectionId", (Object)this.protectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectionId": {
                return Optional.ofNullable(clazz.cast(this.protectionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteProtectionRequest, T> g) {
        return obj -> g.apply((DeleteProtectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ShieldRequest.BuilderImpl
    implements Builder {
        private String protectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProtectionRequest model) {
            super(model);
            this.protectionId(model.protectionId);
        }

        public final String getProtectionId() {
            return this.protectionId;
        }

        @Override
        public final Builder protectionId(String protectionId) {
            this.protectionId = protectionId;
            return this;
        }

        public final void setProtectionId(String protectionId) {
            this.protectionId = protectionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProtectionRequest build() {
            return new DeleteProtectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ShieldRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteProtectionRequest> {
        public Builder protectionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

