/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.LogBucketListCopier;
import software.amazon.awssdk.services.shield.model.ShieldResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDrtAccessResponse
extends ShieldResponse
implements ToCopyableBuilder<Builder, DescribeDrtAccessResponse> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDrtAccessResponse.getter(DescribeDrtAccessResponse::roleArn)).setter(DescribeDrtAccessResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<String>> LOG_BUCKET_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDrtAccessResponse.getter(DescribeDrtAccessResponse::logBucketList)).setter(DescribeDrtAccessResponse.setter(Builder::logBucketList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogBucketList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, LOG_BUCKET_LIST_FIELD));
    private final String roleArn;
    private final List<String> logBucketList;

    private DescribeDrtAccessResponse(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.logBucketList = builder.logBucketList;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public List<String> logBucketList() {
        return this.logBucketList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logBucketList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDrtAccessResponse)) {
            return false;
        }
        DescribeDrtAccessResponse other = (DescribeDrtAccessResponse)((Object)obj);
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.logBucketList(), other.logBucketList());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDrtAccessResponse").add("RoleArn", (Object)this.roleArn()).add("LogBucketList", this.logBucketList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "LogBucketList": {
                return Optional.ofNullable(clazz.cast(this.logBucketList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDrtAccessResponse, T> g) {
        return obj -> g.apply((DescribeDrtAccessResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ShieldResponse.BuilderImpl
    implements Builder {
        private String roleArn;
        private List<String> logBucketList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDrtAccessResponse model) {
            super(model);
            this.roleArn(model.roleArn);
            this.logBucketList(model.logBucketList);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<String> getLogBucketList() {
            return this.logBucketList;
        }

        @Override
        public final Builder logBucketList(Collection<String> logBucketList) {
            this.logBucketList = LogBucketListCopier.copy(logBucketList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logBucketList(String ... logBucketList) {
            this.logBucketList(Arrays.asList(logBucketList));
            return this;
        }

        public final void setLogBucketList(Collection<String> logBucketList) {
            this.logBucketList = LogBucketListCopier.copy(logBucketList);
        }

        @Override
        public DescribeDrtAccessResponse build() {
            return new DescribeDrtAccessResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ShieldResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDrtAccessResponse> {
        public Builder roleArn(String var1);

        public Builder logBucketList(Collection<String> var1);

        public Builder logBucketList(String ... var1);
    }
}

