/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Shield Advanced subscription for an account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Subscription implements SdkPojo, Serializable, ToCopyableBuilder<Subscription.Builder, Subscription> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(Subscription::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(Subscription::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Long> TIME_COMMITMENT_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TimeCommitmentInSeconds").getter(getter(Subscription::timeCommitmentInSeconds))
            .setter(setter(Builder::timeCommitmentInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeCommitmentInSeconds").build())
            .build();

    private static final SdkField<String> AUTO_RENEW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoRenew").getter(getter(Subscription::autoRenewAsString)).setter(setter(Builder::autoRenew))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRenew").build()).build();

    private static final SdkField<List<Limit>> LIMITS_FIELD = SdkField
            .<List<Limit>> builder(MarshallingType.LIST)
            .memberName("Limits")
            .getter(getter(Subscription::limits))
            .setter(setter(Builder::limits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Limit> builder(MarshallingType.SDK_POJO)
                                            .constructor(Limit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROACTIVE_ENGAGEMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProactiveEngagementStatus").getter(getter(Subscription::proactiveEngagementStatusAsString))
            .setter(setter(Builder::proactiveEngagementStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProactiveEngagementStatus").build())
            .build();

    private static final SdkField<SubscriptionLimits> SUBSCRIPTION_LIMITS_FIELD = SdkField
            .<SubscriptionLimits> builder(MarshallingType.SDK_POJO).memberName("SubscriptionLimits")
            .getter(getter(Subscription::subscriptionLimits)).setter(setter(Builder::subscriptionLimits))
            .constructor(SubscriptionLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionLimits").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionArn").getter(getter(Subscription::subscriptionArn)).setter(setter(Builder::subscriptionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, TIME_COMMITMENT_IN_SECONDS_FIELD, AUTO_RENEW_FIELD, LIMITS_FIELD, PROACTIVE_ENGAGEMENT_STATUS_FIELD,
            SUBSCRIPTION_LIMITS_FIELD, SUBSCRIPTION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant startTime;

    private final Instant endTime;

    private final Long timeCommitmentInSeconds;

    private final String autoRenew;

    private final List<Limit> limits;

    private final String proactiveEngagementStatus;

    private final SubscriptionLimits subscriptionLimits;

    private final String subscriptionArn;

    private Subscription(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.timeCommitmentInSeconds = builder.timeCommitmentInSeconds;
        this.autoRenew = builder.autoRenew;
        this.limits = builder.limits;
        this.proactiveEngagementStatus = builder.proactiveEngagementStatus;
        this.subscriptionLimits = builder.subscriptionLimits;
        this.subscriptionArn = builder.subscriptionArn;
    }

    /**
     * <p>
     * The start time of the subscription, in Unix time in seconds.
     * </p>
     * 
     * @return The start time of the subscription, in Unix time in seconds.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time your subscription will end.
     * </p>
     * 
     * @return The date and time your subscription will end.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The length, in seconds, of the Shield Advanced subscription for the account.
     * </p>
     * 
     * @return The length, in seconds, of the Shield Advanced subscription for the account.
     */
    public final Long timeCommitmentInSeconds() {
        return timeCommitmentInSeconds;
    }

    /**
     * <p>
     * If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing subscription
     * period.
     * </p>
     * <p>
     * When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can change
     * this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code> request
     * does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code> remains
     * unchanged.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoRenew} will
     * return {@link AutoRenew#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoRenewAsString}.
     * </p>
     * 
     * @return If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing
     *         subscription period.</p>
     *         <p>
     *         When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can
     *         change this by submitting an <code>UpdateSubscription</code> request. If the
     *         <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the
     *         existing value for <code>AutoRenew</code> remains unchanged.
     * @see AutoRenew
     */
    public final AutoRenew autoRenew() {
        return AutoRenew.fromValue(autoRenew);
    }

    /**
     * <p>
     * If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing subscription
     * period.
     * </p>
     * <p>
     * When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can change
     * this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code> request
     * does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code> remains
     * unchanged.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoRenew} will
     * return {@link AutoRenew#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoRenewAsString}.
     * </p>
     * 
     * @return If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing
     *         subscription period.</p>
     *         <p>
     *         When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can
     *         change this by submitting an <code>UpdateSubscription</code> request. If the
     *         <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the
     *         existing value for <code>AutoRenew</code> remains unchanged.
     * @see AutoRenew
     */
    public final String autoRenewAsString() {
        return autoRenew;
    }

    /**
     * For responses, this returns true if the service returned a value for the Limits property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLimits() {
        return limits != null && !(limits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies how many protections of a given type you can create.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLimits} method.
     * </p>
     * 
     * @return Specifies how many protections of a given type you can create.
     */
    public final List<Limit> limits() {
        return limits;
    }

    /**
     * <p>
     * If <code>ENABLED</code>, the Shield Response Team (SRT) will use email and phone to notify contacts about
     * escalations to the SRT and to initiate proactive customer support.
     * </p>
     * <p>
     * If <code>PENDING</code>, you have requested proactive engagement and the request is pending. The status changes
     * to <code>ENABLED</code> when your request is fully processed.
     * </p>
     * <p>
     * If <code>DISABLED</code>, the SRT will not proactively notify contacts about escalations or to initiate proactive
     * customer support.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #proactiveEngagementStatus} will return {@link ProactiveEngagementStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #proactiveEngagementStatusAsString}.
     * </p>
     * 
     * @return If <code>ENABLED</code>, the Shield Response Team (SRT) will use email and phone to notify contacts about
     *         escalations to the SRT and to initiate proactive customer support.</p>
     *         <p>
     *         If <code>PENDING</code>, you have requested proactive engagement and the request is pending. The status
     *         changes to <code>ENABLED</code> when your request is fully processed.
     *         </p>
     *         <p>
     *         If <code>DISABLED</code>, the SRT will not proactively notify contacts about escalations or to initiate
     *         proactive customer support.
     * @see ProactiveEngagementStatus
     */
    public final ProactiveEngagementStatus proactiveEngagementStatus() {
        return ProactiveEngagementStatus.fromValue(proactiveEngagementStatus);
    }

    /**
     * <p>
     * If <code>ENABLED</code>, the Shield Response Team (SRT) will use email and phone to notify contacts about
     * escalations to the SRT and to initiate proactive customer support.
     * </p>
     * <p>
     * If <code>PENDING</code>, you have requested proactive engagement and the request is pending. The status changes
     * to <code>ENABLED</code> when your request is fully processed.
     * </p>
     * <p>
     * If <code>DISABLED</code>, the SRT will not proactively notify contacts about escalations or to initiate proactive
     * customer support.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #proactiveEngagementStatus} will return {@link ProactiveEngagementStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #proactiveEngagementStatusAsString}.
     * </p>
     * 
     * @return If <code>ENABLED</code>, the Shield Response Team (SRT) will use email and phone to notify contacts about
     *         escalations to the SRT and to initiate proactive customer support.</p>
     *         <p>
     *         If <code>PENDING</code>, you have requested proactive engagement and the request is pending. The status
     *         changes to <code>ENABLED</code> when your request is fully processed.
     *         </p>
     *         <p>
     *         If <code>DISABLED</code>, the SRT will not proactively notify contacts about escalations or to initiate
     *         proactive customer support.
     * @see ProactiveEngagementStatus
     */
    public final String proactiveEngagementStatusAsString() {
        return proactiveEngagementStatus;
    }

    /**
     * <p>
     * Limits settings for your subscription.
     * </p>
     * 
     * @return Limits settings for your subscription.
     */
    public final SubscriptionLimits subscriptionLimits() {
        return subscriptionLimits;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the subscription.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the subscription.
     */
    public final String subscriptionArn() {
        return subscriptionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(timeCommitmentInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(autoRenewAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLimits() ? limits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(proactiveEngagementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionLimits());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(timeCommitmentInSeconds(), other.timeCommitmentInSeconds())
                && Objects.equals(autoRenewAsString(), other.autoRenewAsString()) && hasLimits() == other.hasLimits()
                && Objects.equals(limits(), other.limits())
                && Objects.equals(proactiveEngagementStatusAsString(), other.proactiveEngagementStatusAsString())
                && Objects.equals(subscriptionLimits(), other.subscriptionLimits())
                && Objects.equals(subscriptionArn(), other.subscriptionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Subscription").add("StartTime", startTime()).add("EndTime", endTime())
                .add("TimeCommitmentInSeconds", timeCommitmentInSeconds()).add("AutoRenew", autoRenewAsString())
                .add("Limits", hasLimits() ? limits() : null)
                .add("ProactiveEngagementStatus", proactiveEngagementStatusAsString())
                .add("SubscriptionLimits", subscriptionLimits()).add("SubscriptionArn", subscriptionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "TimeCommitmentInSeconds":
            return Optional.ofNullable(clazz.cast(timeCommitmentInSeconds()));
        case "AutoRenew":
            return Optional.ofNullable(clazz.cast(autoRenewAsString()));
        case "Limits":
            return Optional.ofNullable(clazz.cast(limits()));
        case "ProactiveEngagementStatus":
            return Optional.ofNullable(clazz.cast(proactiveEngagementStatusAsString()));
        case "SubscriptionLimits":
            return Optional.ofNullable(clazz.cast(subscriptionLimits()));
        case "SubscriptionArn":
            return Optional.ofNullable(clazz.cast(subscriptionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("TimeCommitmentInSeconds", TIME_COMMITMENT_IN_SECONDS_FIELD);
        map.put("AutoRenew", AUTO_RENEW_FIELD);
        map.put("Limits", LIMITS_FIELD);
        map.put("ProactiveEngagementStatus", PROACTIVE_ENGAGEMENT_STATUS_FIELD);
        map.put("SubscriptionLimits", SUBSCRIPTION_LIMITS_FIELD);
        map.put("SubscriptionArn", SUBSCRIPTION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Subscription, T> g) {
        return obj -> g.apply((Subscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Subscription> {
        /**
         * <p>
         * The start time of the subscription, in Unix time in seconds.
         * </p>
         * 
         * @param startTime
         *        The start time of the subscription, in Unix time in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time your subscription will end.
         * </p>
         * 
         * @param endTime
         *        The date and time your subscription will end.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The length, in seconds, of the Shield Advanced subscription for the account.
         * </p>
         * 
         * @param timeCommitmentInSeconds
         *        The length, in seconds, of the Shield Advanced subscription for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeCommitmentInSeconds(Long timeCommitmentInSeconds);

        /**
         * <p>
         * If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing
         * subscription period.
         * </p>
         * <p>
         * When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can
         * change this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code>
         * request does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code>
         * remains unchanged.
         * </p>
         * 
         * @param autoRenew
         *        If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing
         *        subscription period.</p>
         *        <p>
         *        When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You
         *        can change this by submitting an <code>UpdateSubscription</code> request. If the
         *        <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the
         *        existing value for <code>AutoRenew</code> remains unchanged.
         * @see AutoRenew
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRenew
         */
        Builder autoRenew(String autoRenew);

        /**
         * <p>
         * If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing
         * subscription period.
         * </p>
         * <p>
         * When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can
         * change this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code>
         * request does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code>
         * remains unchanged.
         * </p>
         * 
         * @param autoRenew
         *        If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing
         *        subscription period.</p>
         *        <p>
         *        When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You
         *        can change this by submitting an <code>UpdateSubscription</code> request. If the
         *        <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the
         *        existing value for <code>AutoRenew</code> remains unchanged.
         * @see AutoRenew
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRenew
         */
        Builder autoRenew(AutoRenew autoRenew);

        /**
         * <p>
         * Specifies how many protections of a given type you can create.
         * </p>
         * 
         * @param limits
         *        Specifies how many protections of a given type you can create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(Collection<Limit> limits);

        /**
         * <p>
         * Specifies how many protections of a given type you can create.
         * </p>
         * 
         * @param limits
         *        Specifies how many protections of a given type you can create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(Limit... limits);

        /**
         * <p>
         * Specifies how many protections of a given type you can create.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.shield.model.Limit.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.shield.model.Limit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.shield.model.Limit.Builder#build()} is called immediately and its
         * result is passed to {@link #limits(List<Limit>)}.
         * 
         * @param limits
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.shield.model.Limit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limits(java.util.Collection<Limit>)
         */
        Builder limits(Consumer<Limit.Builder>... limits);

        /**
         * <p>
         * If <code>ENABLED</code>, the Shield Response Team (SRT) will use email and phone to notify contacts about
         * escalations to the SRT and to initiate proactive customer support.
         * </p>
         * <p>
         * If <code>PENDING</code>, you have requested proactive engagement and the request is pending. The status
         * changes to <code>ENABLED</code> when your request is fully processed.
         * </p>
         * <p>
         * If <code>DISABLED</code>, the SRT will not proactively notify contacts about escalations or to initiate
         * proactive customer support.
         * </p>
         * 
         * @param proactiveEngagementStatus
         *        If <code>ENABLED</code>, the Shield Response Team (SRT) will use email and phone to notify contacts
         *        about escalations to the SRT and to initiate proactive customer support.</p>
         *        <p>
         *        If <code>PENDING</code>, you have requested proactive engagement and the request is pending. The
         *        status changes to <code>ENABLED</code> when your request is fully processed.
         *        </p>
         *        <p>
         *        If <code>DISABLED</code>, the SRT will not proactively notify contacts about escalations or to
         *        initiate proactive customer support.
         * @see ProactiveEngagementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProactiveEngagementStatus
         */
        Builder proactiveEngagementStatus(String proactiveEngagementStatus);

        /**
         * <p>
         * If <code>ENABLED</code>, the Shield Response Team (SRT) will use email and phone to notify contacts about
         * escalations to the SRT and to initiate proactive customer support.
         * </p>
         * <p>
         * If <code>PENDING</code>, you have requested proactive engagement and the request is pending. The status
         * changes to <code>ENABLED</code> when your request is fully processed.
         * </p>
         * <p>
         * If <code>DISABLED</code>, the SRT will not proactively notify contacts about escalations or to initiate
         * proactive customer support.
         * </p>
         * 
         * @param proactiveEngagementStatus
         *        If <code>ENABLED</code>, the Shield Response Team (SRT) will use email and phone to notify contacts
         *        about escalations to the SRT and to initiate proactive customer support.</p>
         *        <p>
         *        If <code>PENDING</code>, you have requested proactive engagement and the request is pending. The
         *        status changes to <code>ENABLED</code> when your request is fully processed.
         *        </p>
         *        <p>
         *        If <code>DISABLED</code>, the SRT will not proactively notify contacts about escalations or to
         *        initiate proactive customer support.
         * @see ProactiveEngagementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProactiveEngagementStatus
         */
        Builder proactiveEngagementStatus(ProactiveEngagementStatus proactiveEngagementStatus);

        /**
         * <p>
         * Limits settings for your subscription.
         * </p>
         * 
         * @param subscriptionLimits
         *        Limits settings for your subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionLimits(SubscriptionLimits subscriptionLimits);

        /**
         * <p>
         * Limits settings for your subscription.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscriptionLimits.Builder} avoiding the
         * need to create one manually via {@link SubscriptionLimits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscriptionLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #subscriptionLimits(SubscriptionLimits)}.
         * 
         * @param subscriptionLimits
         *        a consumer that will call methods on {@link SubscriptionLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriptionLimits(SubscriptionLimits)
         */
        default Builder subscriptionLimits(Consumer<SubscriptionLimits.Builder> subscriptionLimits) {
            return subscriptionLimits(SubscriptionLimits.builder().applyMutation(subscriptionLimits).build());
        }

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the subscription.
         * </p>
         * 
         * @param subscriptionArn
         *        The ARN (Amazon Resource Name) of the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionArn(String subscriptionArn);
    }

    static final class BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private Long timeCommitmentInSeconds;

        private String autoRenew;

        private List<Limit> limits = DefaultSdkAutoConstructList.getInstance();

        private String proactiveEngagementStatus;

        private SubscriptionLimits subscriptionLimits;

        private String subscriptionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            startTime(model.startTime);
            endTime(model.endTime);
            timeCommitmentInSeconds(model.timeCommitmentInSeconds);
            autoRenew(model.autoRenew);
            limits(model.limits);
            proactiveEngagementStatus(model.proactiveEngagementStatus);
            subscriptionLimits(model.subscriptionLimits);
            subscriptionArn(model.subscriptionArn);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Long getTimeCommitmentInSeconds() {
            return timeCommitmentInSeconds;
        }

        public final void setTimeCommitmentInSeconds(Long timeCommitmentInSeconds) {
            this.timeCommitmentInSeconds = timeCommitmentInSeconds;
        }

        @Override
        public final Builder timeCommitmentInSeconds(Long timeCommitmentInSeconds) {
            this.timeCommitmentInSeconds = timeCommitmentInSeconds;
            return this;
        }

        public final String getAutoRenew() {
            return autoRenew;
        }

        public final void setAutoRenew(String autoRenew) {
            this.autoRenew = autoRenew;
        }

        @Override
        public final Builder autoRenew(String autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        @Override
        public final Builder autoRenew(AutoRenew autoRenew) {
            this.autoRenew(autoRenew == null ? null : autoRenew.toString());
            return this;
        }

        public final List<Limit.Builder> getLimits() {
            List<Limit.Builder> result = LimitsCopier.copyToBuilder(this.limits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLimits(Collection<Limit.BuilderImpl> limits) {
            this.limits = LimitsCopier.copyFromBuilder(limits);
        }

        @Override
        public final Builder limits(Collection<Limit> limits) {
            this.limits = LimitsCopier.copy(limits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limits(Limit... limits) {
            limits(Arrays.asList(limits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limits(Consumer<Limit.Builder>... limits) {
            limits(Stream.of(limits).map(c -> Limit.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProactiveEngagementStatus() {
            return proactiveEngagementStatus;
        }

        public final void setProactiveEngagementStatus(String proactiveEngagementStatus) {
            this.proactiveEngagementStatus = proactiveEngagementStatus;
        }

        @Override
        public final Builder proactiveEngagementStatus(String proactiveEngagementStatus) {
            this.proactiveEngagementStatus = proactiveEngagementStatus;
            return this;
        }

        @Override
        public final Builder proactiveEngagementStatus(ProactiveEngagementStatus proactiveEngagementStatus) {
            this.proactiveEngagementStatus(proactiveEngagementStatus == null ? null : proactiveEngagementStatus.toString());
            return this;
        }

        public final SubscriptionLimits.Builder getSubscriptionLimits() {
            return subscriptionLimits != null ? subscriptionLimits.toBuilder() : null;
        }

        public final void setSubscriptionLimits(SubscriptionLimits.BuilderImpl subscriptionLimits) {
            this.subscriptionLimits = subscriptionLimits != null ? subscriptionLimits.build() : null;
        }

        @Override
        public final Builder subscriptionLimits(SubscriptionLimits subscriptionLimits) {
            this.subscriptionLimits = subscriptionLimits;
            return this;
        }

        public final String getSubscriptionArn() {
            return subscriptionArn;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        @Override
        public Subscription build() {
            return new Subscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
