/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A contributor to the attack and their contribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Contributor implements SdkPojo, Serializable, ToCopyableBuilder<Contributor.Builder, Contributor> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Contributor::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Long> VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Value")
            .getter(getter(Contributor::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Long value;

    private Contributor(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the contributor. The type of name that you'll find here depends on the
     * <code>AttackPropertyIdentifier</code> setting in the <code>AttackProperty</code> where this contributor is
     * defined. For example, if the <code>AttackPropertyIdentifier</code> is <code>SOURCE_COUNTRY</code>, the
     * <code>Name</code> could be <code>United States</code>.
     * </p>
     * 
     * @return The name of the contributor. The type of name that you'll find here depends on the
     *         <code>AttackPropertyIdentifier</code> setting in the <code>AttackProperty</code> where this contributor
     *         is defined. For example, if the <code>AttackPropertyIdentifier</code> is <code>SOURCE_COUNTRY</code>, the
     *         <code>Name</code> could be <code>United States</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The contribution of this contributor expressed in <a>Protection</a> units. For example <code>10,000</code>.
     * </p>
     * 
     * @return The contribution of this contributor expressed in <a>Protection</a> units. For example
     *         <code>10,000</code>.
     */
    public final Long value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Contributor)) {
            return false;
        }
        Contributor other = (Contributor) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Contributor").add("Name", name()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Contributor, T> g) {
        return obj -> g.apply((Contributor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Contributor> {
        /**
         * <p>
         * The name of the contributor. The type of name that you'll find here depends on the
         * <code>AttackPropertyIdentifier</code> setting in the <code>AttackProperty</code> where this contributor is
         * defined. For example, if the <code>AttackPropertyIdentifier</code> is <code>SOURCE_COUNTRY</code>, the
         * <code>Name</code> could be <code>United States</code>.
         * </p>
         * 
         * @param name
         *        The name of the contributor. The type of name that you'll find here depends on the
         *        <code>AttackPropertyIdentifier</code> setting in the <code>AttackProperty</code> where this
         *        contributor is defined. For example, if the <code>AttackPropertyIdentifier</code> is
         *        <code>SOURCE_COUNTRY</code>, the <code>Name</code> could be <code>United States</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The contribution of this contributor expressed in <a>Protection</a> units. For example <code>10,000</code>.
         * </p>
         * 
         * @param value
         *        The contribution of this contributor expressed in <a>Protection</a> units. For example
         *        <code>10,000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Long value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Long value;

        private BuilderImpl() {
        }

        private BuilderImpl(Contributor model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getValue() {
            return value;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        @Override
        public Contributor build() {
            return new Contributor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
