/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.shield.model.ShieldRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateHealthCheckRequest
extends ShieldRequest
implements ToCopyableBuilder<Builder, DisassociateHealthCheckRequest> {
    private static final SdkField<String> PROTECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectionId").getter(DisassociateHealthCheckRequest.getter(DisassociateHealthCheckRequest::protectionId)).setter(DisassociateHealthCheckRequest.setter(Builder::protectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionId").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthCheckArn").getter(DisassociateHealthCheckRequest.getter(DisassociateHealthCheckRequest::healthCheckArn)).setter(DisassociateHealthCheckRequest.setter(Builder::healthCheckArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_ID_FIELD, HEALTH_CHECK_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociateHealthCheckRequest.memberNameToFieldInitializer();
    private final String protectionId;
    private final String healthCheckArn;

    private DisassociateHealthCheckRequest(BuilderImpl builder) {
        super(builder);
        this.protectionId = builder.protectionId;
        this.healthCheckArn = builder.healthCheckArn;
    }

    public final String protectionId() {
        return this.protectionId;
    }

    public final String healthCheckArn() {
        return this.healthCheckArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.protectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateHealthCheckRequest)) {
            return false;
        }
        DisassociateHealthCheckRequest other = (DisassociateHealthCheckRequest)((Object)obj);
        return Objects.equals(this.protectionId(), other.protectionId()) && Objects.equals(this.healthCheckArn(), other.healthCheckArn());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateHealthCheckRequest").add("ProtectionId", (Object)this.protectionId()).add("HealthCheckArn", (Object)this.healthCheckArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectionId": {
                return Optional.ofNullable(clazz.cast(this.protectionId()));
            }
            case "HealthCheckArn": {
                return Optional.ofNullable(clazz.cast(this.healthCheckArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ProtectionId", PROTECTION_ID_FIELD);
        map.put("HealthCheckArn", HEALTH_CHECK_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateHealthCheckRequest, T> g) {
        return obj -> g.apply((DisassociateHealthCheckRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ShieldRequest.BuilderImpl
    implements Builder {
        private String protectionId;
        private String healthCheckArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateHealthCheckRequest model) {
            super(model);
            this.protectionId(model.protectionId);
            this.healthCheckArn(model.healthCheckArn);
        }

        public final String getProtectionId() {
            return this.protectionId;
        }

        public final void setProtectionId(String protectionId) {
            this.protectionId = protectionId;
        }

        @Override
        public final Builder protectionId(String protectionId) {
            this.protectionId = protectionId;
            return this;
        }

        public final String getHealthCheckArn() {
            return this.healthCheckArn;
        }

        public final void setHealthCheckArn(String healthCheckArn) {
            this.healthCheckArn = healthCheckArn;
        }

        @Override
        public final Builder healthCheckArn(String healthCheckArn) {
            this.healthCheckArn = healthCheckArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateHealthCheckRequest build() {
            return new DisassociateHealthCheckRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ShieldRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateHealthCheckRequest> {
        public Builder protectionId(String var1);

        public Builder healthCheckArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

