/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.shield.ShieldAsyncClient;
import software.amazon.awssdk.services.shield.internal.UserAgentUtils;
import software.amazon.awssdk.services.shield.model.AttackSummary;
import software.amazon.awssdk.services.shield.model.ListAttacksRequest;
import software.amazon.awssdk.services.shield.model.ListAttacksResponse;

public class ListAttacksPublisher
implements SdkPublisher<ListAttacksResponse> {
    private final ShieldAsyncClient client;
    private final ListAttacksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAttacksPublisher(ShieldAsyncClient client, ListAttacksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAttacksPublisher(ShieldAsyncClient client, ListAttacksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAttacksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAttacksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AttackSummary> attackSummaries() {
        Function<ListAttacksResponse, Iterator> getIterator = response -> {
            if (response != null && response.attackSummaries() != null) {
                return response.attackSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAttacksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAttacksResponseFetcher
    implements AsyncPageFetcher<ListAttacksResponse> {
        private ListAttacksResponseFetcher() {
        }

        public boolean hasNextPage(ListAttacksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAttacksResponse> nextPage(ListAttacksResponse previousPage) {
            if (previousPage == null) {
                return ListAttacksPublisher.this.client.listAttacks(ListAttacksPublisher.this.firstRequest);
            }
            return ListAttacksPublisher.this.client.listAttacks((ListAttacksRequest)((Object)ListAttacksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

