/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateProactiveEngagementDetailsRequest extends ShieldRequest implements
        ToCopyableBuilder<AssociateProactiveEngagementDetailsRequest.Builder, AssociateProactiveEngagementDetailsRequest> {
    private static final SdkField<List<EmergencyContact>> EMERGENCY_CONTACT_LIST_FIELD = SdkField
            .<List<EmergencyContact>> builder(MarshallingType.LIST)
            .memberName("EmergencyContactList")
            .getter(getter(AssociateProactiveEngagementDetailsRequest::emergencyContactList))
            .setter(setter(Builder::emergencyContactList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmergencyContactList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EmergencyContact> builder(MarshallingType.SDK_POJO)
                                            .constructor(EmergencyContact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMERGENCY_CONTACT_LIST_FIELD));

    private final List<EmergencyContact> emergencyContactList;

    private AssociateProactiveEngagementDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.emergencyContactList = builder.emergencyContactList;
    }

    /**
     * For responses, this returns true if the service returned a value for the EmergencyContactList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEmergencyContactList() {
        return emergencyContactList != null && !(emergencyContactList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for
     * escalations to the SRT and to initiate proactive customer support.
     * </p>
     * <p>
     * To enable proactive engagement, the contact list must include at least one phone number.
     * </p>
     * <note>
     * <p>
     * The contacts that you provide here replace any contacts that were already defined. If you already have contacts
     * defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code> and then
     * provide it here.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmergencyContactList} method.
     * </p>
     * 
     * @return A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you
     *         for escalations to the SRT and to initiate proactive customer support. </p>
     *         <p>
     *         To enable proactive engagement, the contact list must include at least one phone number.
     *         </p>
     *         <note>
     *         <p>
     *         The contacts that you provide here replace any contacts that were already defined. If you already have
     *         contacts defined and want to use them, retrieve the list using
     *         <code>DescribeEmergencyContactSettings</code> and then provide it here.
     *         </p>
     */
    public final List<EmergencyContact> emergencyContactList() {
        return emergencyContactList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEmergencyContactList() ? emergencyContactList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateProactiveEngagementDetailsRequest)) {
            return false;
        }
        AssociateProactiveEngagementDetailsRequest other = (AssociateProactiveEngagementDetailsRequest) obj;
        return hasEmergencyContactList() == other.hasEmergencyContactList()
                && Objects.equals(emergencyContactList(), other.emergencyContactList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateProactiveEngagementDetailsRequest")
                .add("EmergencyContactList", hasEmergencyContactList() ? emergencyContactList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmergencyContactList":
            return Optional.ofNullable(clazz.cast(emergencyContactList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateProactiveEngagementDetailsRequest, T> g) {
        return obj -> g.apply((AssociateProactiveEngagementDetailsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ShieldRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateProactiveEngagementDetailsRequest> {
        /**
         * <p>
         * A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for
         * escalations to the SRT and to initiate proactive customer support.
         * </p>
         * <p>
         * To enable proactive engagement, the contact list must include at least one phone number.
         * </p>
         * <note>
         * <p>
         * The contacts that you provide here replace any contacts that were already defined. If you already have
         * contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code>
         * and then provide it here.
         * </p>
         * </note>
         * 
         * @param emergencyContactList
         *        A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you
         *        for escalations to the SRT and to initiate proactive customer support. </p>
         *        <p>
         *        To enable proactive engagement, the contact list must include at least one phone number.
         *        </p>
         *        <note>
         *        <p>
         *        The contacts that you provide here replace any contacts that were already defined. If you already have
         *        contacts defined and want to use them, retrieve the list using
         *        <code>DescribeEmergencyContactSettings</code> and then provide it here.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emergencyContactList(Collection<EmergencyContact> emergencyContactList);

        /**
         * <p>
         * A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for
         * escalations to the SRT and to initiate proactive customer support.
         * </p>
         * <p>
         * To enable proactive engagement, the contact list must include at least one phone number.
         * </p>
         * <note>
         * <p>
         * The contacts that you provide here replace any contacts that were already defined. If you already have
         * contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code>
         * and then provide it here.
         * </p>
         * </note>
         * 
         * @param emergencyContactList
         *        A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you
         *        for escalations to the SRT and to initiate proactive customer support. </p>
         *        <p>
         *        To enable proactive engagement, the contact list must include at least one phone number.
         *        </p>
         *        <note>
         *        <p>
         *        The contacts that you provide here replace any contacts that were already defined. If you already have
         *        contacts defined and want to use them, retrieve the list using
         *        <code>DescribeEmergencyContactSettings</code> and then provide it here.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emergencyContactList(EmergencyContact... emergencyContactList);

        /**
         * <p>
         * A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for
         * escalations to the SRT and to initiate proactive customer support.
         * </p>
         * <p>
         * To enable proactive engagement, the contact list must include at least one phone number.
         * </p>
         * <note>
         * <p>
         * The contacts that you provide here replace any contacts that were already defined. If you already have
         * contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code>
         * and then provide it here.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.shield.model.EmergencyContact.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.shield.model.EmergencyContact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.shield.model.EmergencyContact.Builder#build()} is called immediately
         * and its result is passed to {@link #emergencyContactList(List<EmergencyContact>)}.
         * 
         * @param emergencyContactList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.shield.model.EmergencyContact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emergencyContactList(java.util.Collection<EmergencyContact>)
         */
        Builder emergencyContactList(Consumer<EmergencyContact.Builder>... emergencyContactList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ShieldRequest.BuilderImpl implements Builder {
        private List<EmergencyContact> emergencyContactList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateProactiveEngagementDetailsRequest model) {
            super(model);
            emergencyContactList(model.emergencyContactList);
        }

        public final List<EmergencyContact.Builder> getEmergencyContactList() {
            List<EmergencyContact.Builder> result = EmergencyContactListCopier.copyToBuilder(this.emergencyContactList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmergencyContactList(Collection<EmergencyContact.BuilderImpl> emergencyContactList) {
            this.emergencyContactList = EmergencyContactListCopier.copyFromBuilder(emergencyContactList);
        }

        @Override
        public final Builder emergencyContactList(Collection<EmergencyContact> emergencyContactList) {
            this.emergencyContactList = EmergencyContactListCopier.copy(emergencyContactList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emergencyContactList(EmergencyContact... emergencyContactList) {
            emergencyContactList(Arrays.asList(emergencyContactList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emergencyContactList(Consumer<EmergencyContact.Builder>... emergencyContactList) {
            emergencyContactList(Stream.of(emergencyContactList).map(c -> EmergencyContact.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateProactiveEngagementDetailsRequest build() {
            return new AssociateProactiveEngagementDetailsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
