/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.shield.model.ShieldRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourcesInProtectionGroupRequest
extends ShieldRequest
implements ToCopyableBuilder<Builder, ListResourcesInProtectionGroupRequest> {
    private static final SdkField<String> PROTECTION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectionGroupId").getter(ListResourcesInProtectionGroupRequest.getter(ListResourcesInProtectionGroupRequest::protectionGroupId)).setter(ListResourcesInProtectionGroupRequest.setter(Builder::protectionGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionGroupId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourcesInProtectionGroupRequest.getter(ListResourcesInProtectionGroupRequest::nextToken)).setter(ListResourcesInProtectionGroupRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListResourcesInProtectionGroupRequest.getter(ListResourcesInProtectionGroupRequest::maxResults)).setter(ListResourcesInProtectionGroupRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_GROUP_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String protectionGroupId;
    private final String nextToken;
    private final Integer maxResults;

    private ListResourcesInProtectionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.protectionGroupId = builder.protectionGroupId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String protectionGroupId() {
        return this.protectionGroupId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.protectionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesInProtectionGroupRequest)) {
            return false;
        }
        ListResourcesInProtectionGroupRequest other = (ListResourcesInProtectionGroupRequest)((Object)obj);
        return Objects.equals(this.protectionGroupId(), other.protectionGroupId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourcesInProtectionGroupRequest").add("ProtectionGroupId", (Object)this.protectionGroupId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectionGroupId": {
                return Optional.ofNullable(clazz.cast(this.protectionGroupId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesInProtectionGroupRequest, T> g) {
        return obj -> g.apply((ListResourcesInProtectionGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ShieldRequest.BuilderImpl
    implements Builder {
        private String protectionGroupId;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesInProtectionGroupRequest model) {
            super(model);
            this.protectionGroupId(model.protectionGroupId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getProtectionGroupId() {
            return this.protectionGroupId;
        }

        public final void setProtectionGroupId(String protectionGroupId) {
            this.protectionGroupId = protectionGroupId;
        }

        @Override
        public final Builder protectionGroupId(String protectionGroupId) {
            this.protectionGroupId = protectionGroupId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourcesInProtectionGroupRequest build() {
            return new ListResourcesInProtectionGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ShieldRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourcesInProtectionGroupRequest> {
        public Builder protectionGroupId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

