/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.shield.model.ResponseAction;
import software.amazon.awssdk.services.shield.model.ShieldRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableApplicationLayerAutomaticResponseRequest
extends ShieldRequest
implements ToCopyableBuilder<Builder, EnableApplicationLayerAutomaticResponseRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(EnableApplicationLayerAutomaticResponseRequest.getter(EnableApplicationLayerAutomaticResponseRequest::resourceArn)).setter(EnableApplicationLayerAutomaticResponseRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<ResponseAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Action").getter(EnableApplicationLayerAutomaticResponseRequest.getter(EnableApplicationLayerAutomaticResponseRequest::action)).setter(EnableApplicationLayerAutomaticResponseRequest.setter(Builder::action)).constructor(ResponseAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, ACTION_FIELD));
    private final String resourceArn;
    private final ResponseAction action;

    private EnableApplicationLayerAutomaticResponseRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.action = builder.action;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final ResponseAction action() {
        return this.action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableApplicationLayerAutomaticResponseRequest)) {
            return false;
        }
        EnableApplicationLayerAutomaticResponseRequest other = (EnableApplicationLayerAutomaticResponseRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.action(), other.action());
    }

    public final String toString() {
        return ToString.builder((String)"EnableApplicationLayerAutomaticResponseRequest").add("ResourceArn", (Object)this.resourceArn()).add("Action", (Object)this.action()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableApplicationLayerAutomaticResponseRequest, T> g) {
        return obj -> g.apply((EnableApplicationLayerAutomaticResponseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ShieldRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private ResponseAction action;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableApplicationLayerAutomaticResponseRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.action(model.action);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final ResponseAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(ResponseAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(ResponseAction action) {
            this.action = action;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableApplicationLayerAutomaticResponseRequest build() {
            return new EnableApplicationLayerAutomaticResponseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ShieldRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableApplicationLayerAutomaticResponseRequest> {
        public Builder resourceArn(String var1);

        public Builder action(ResponseAction var1);

        default public Builder action(Consumer<ResponseAction.Builder> action) {
            return this.action((ResponseAction)((ResponseAction.Builder)ResponseAction.builder().applyMutation(action)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

