/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attack information for the specified SubResource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubResourceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SubResourceSummary.Builder, SubResourceSummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SubResourceSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(SubResourceSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<List<SummarizedAttackVector>> ATTACK_VECTORS_FIELD = SdkField
            .<List<SummarizedAttackVector>> builder(MarshallingType.LIST)
            .memberName("AttackVectors")
            .getter(getter(SubResourceSummary::attackVectors))
            .setter(setter(Builder::attackVectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackVectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SummarizedAttackVector> builder(MarshallingType.SDK_POJO)
                                            .constructor(SummarizedAttackVector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SummarizedCounter>> COUNTERS_FIELD = SdkField
            .<List<SummarizedCounter>> builder(MarshallingType.LIST)
            .memberName("Counters")
            .getter(getter(SubResourceSummary::counters))
            .setter(setter(Builder::counters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Counters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SummarizedCounter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SummarizedCounter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ID_FIELD,
            ATTACK_VECTORS_FIELD, COUNTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String id;

    private final List<SummarizedAttackVector> attackVectors;

    private final List<SummarizedCounter> counters;

    private SubResourceSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.attackVectors = builder.attackVectors;
        this.counters = builder.counters;
    }

    /**
     * <p>
     * The <code>SubResource</code> type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SubResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The <code>SubResource</code> type.
     * @see SubResourceType
     */
    public final SubResourceType type() {
        return SubResourceType.fromValue(type);
    }

    /**
     * <p>
     * The <code>SubResource</code> type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SubResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The <code>SubResource</code> type.
     * @see SubResourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The unique identifier (ID) of the <code>SubResource</code>.
     * </p>
     * 
     * @return The unique identifier (ID) of the <code>SubResource</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttackVectors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttackVectors() {
        return attackVectors != null && !(attackVectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of attack types and associated counters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttackVectors} method.
     * </p>
     * 
     * @return The list of attack types and associated counters.
     */
    public final List<SummarizedAttackVector> attackVectors() {
        return attackVectors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Counters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCounters() {
        return counters != null && !(counters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The counters that describe the details of the attack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCounters} method.
     * </p>
     * 
     * @return The counters that describe the details of the attack.
     */
    public final List<SummarizedCounter> counters() {
        return counters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttackVectors() ? attackVectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCounters() ? counters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubResourceSummary)) {
            return false;
        }
        SubResourceSummary other = (SubResourceSummary) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(id(), other.id())
                && hasAttackVectors() == other.hasAttackVectors() && Objects.equals(attackVectors(), other.attackVectors())
                && hasCounters() == other.hasCounters() && Objects.equals(counters(), other.counters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubResourceSummary").add("Type", typeAsString()).add("Id", id())
                .add("AttackVectors", hasAttackVectors() ? attackVectors() : null)
                .add("Counters", hasCounters() ? counters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "AttackVectors":
            return Optional.ofNullable(clazz.cast(attackVectors()));
        case "Counters":
            return Optional.ofNullable(clazz.cast(counters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubResourceSummary, T> g) {
        return obj -> g.apply((SubResourceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubResourceSummary> {
        /**
         * <p>
         * The <code>SubResource</code> type.
         * </p>
         * 
         * @param type
         *        The <code>SubResource</code> type.
         * @see SubResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubResourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The <code>SubResource</code> type.
         * </p>
         * 
         * @param type
         *        The <code>SubResource</code> type.
         * @see SubResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubResourceType
         */
        Builder type(SubResourceType type);

        /**
         * <p>
         * The unique identifier (ID) of the <code>SubResource</code>.
         * </p>
         * 
         * @param id
         *        The unique identifier (ID) of the <code>SubResource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The list of attack types and associated counters.
         * </p>
         * 
         * @param attackVectors
         *        The list of attack types and associated counters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackVectors(Collection<SummarizedAttackVector> attackVectors);

        /**
         * <p>
         * The list of attack types and associated counters.
         * </p>
         * 
         * @param attackVectors
         *        The list of attack types and associated counters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackVectors(SummarizedAttackVector... attackVectors);

        /**
         * <p>
         * The list of attack types and associated counters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.shield.model.SummarizedAttackVector.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.shield.model.SummarizedAttackVector#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.shield.model.SummarizedAttackVector.Builder#build()} is called
         * immediately and its result is passed to {@link #attackVectors(List<SummarizedAttackVector>)}.
         * 
         * @param attackVectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.shield.model.SummarizedAttackVector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attackVectors(java.util.Collection<SummarizedAttackVector>)
         */
        Builder attackVectors(Consumer<SummarizedAttackVector.Builder>... attackVectors);

        /**
         * <p>
         * The counters that describe the details of the attack.
         * </p>
         * 
         * @param counters
         *        The counters that describe the details of the attack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder counters(Collection<SummarizedCounter> counters);

        /**
         * <p>
         * The counters that describe the details of the attack.
         * </p>
         * 
         * @param counters
         *        The counters that describe the details of the attack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder counters(SummarizedCounter... counters);

        /**
         * <p>
         * The counters that describe the details of the attack.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.shield.model.SummarizedCounter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.shield.model.SummarizedCounter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.shield.model.SummarizedCounter.Builder#build()} is called immediately
         * and its result is passed to {@link #counters(List<SummarizedCounter>)}.
         * 
         * @param counters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.shield.model.SummarizedCounter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #counters(java.util.Collection<SummarizedCounter>)
         */
        Builder counters(Consumer<SummarizedCounter.Builder>... counters);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String id;

        private List<SummarizedAttackVector> attackVectors = DefaultSdkAutoConstructList.getInstance();

        private List<SummarizedCounter> counters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubResourceSummary model) {
            type(model.type);
            id(model.id);
            attackVectors(model.attackVectors);
            counters(model.counters);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SubResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<SummarizedAttackVector.Builder> getAttackVectors() {
            List<SummarizedAttackVector.Builder> result = SummarizedAttackVectorListCopier.copyToBuilder(this.attackVectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttackVectors(Collection<SummarizedAttackVector.BuilderImpl> attackVectors) {
            this.attackVectors = SummarizedAttackVectorListCopier.copyFromBuilder(attackVectors);
        }

        @Override
        public final Builder attackVectors(Collection<SummarizedAttackVector> attackVectors) {
            this.attackVectors = SummarizedAttackVectorListCopier.copy(attackVectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackVectors(SummarizedAttackVector... attackVectors) {
            attackVectors(Arrays.asList(attackVectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackVectors(Consumer<SummarizedAttackVector.Builder>... attackVectors) {
            attackVectors(Stream.of(attackVectors).map(c -> SummarizedAttackVector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SummarizedCounter.Builder> getCounters() {
            List<SummarizedCounter.Builder> result = SummarizedCounterListCopier.copyToBuilder(this.counters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCounters(Collection<SummarizedCounter.BuilderImpl> counters) {
            this.counters = SummarizedCounterListCopier.copyFromBuilder(counters);
        }

        @Override
        public final Builder counters(Collection<SummarizedCounter> counters) {
            this.counters = SummarizedCounterListCopier.copy(counters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder counters(SummarizedCounter... counters) {
            counters(Arrays.asList(counters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder counters(Consumer<SummarizedCounter.Builder>... counters) {
            counters(Stream.of(counters).map(c -> SummarizedCounter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SubResourceSummary build() {
            return new SubResourceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
