/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the attack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttackVectorDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<AttackVectorDescription.Builder, AttackVectorDescription> {
    private static final SdkField<String> VECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VectorType").getter(getter(AttackVectorDescription::vectorType)).setter(setter(Builder::vectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VectorType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vectorType;

    private AttackVectorDescription(BuilderImpl builder) {
        this.vectorType = builder.vectorType;
    }

    /**
     * <p>
     * The attack type. Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * UDP_TRAFFIC
     * </p>
     * </li>
     * <li>
     * <p>
     * UDP_FRAGMENT
     * </p>
     * </li>
     * <li>
     * <p>
     * GENERIC_UDP_REFLECTION
     * </p>
     * </li>
     * <li>
     * <p>
     * DNS_REFLECTION
     * </p>
     * </li>
     * <li>
     * <p>
     * NTP_REFLECTION
     * </p>
     * </li>
     * <li>
     * <p>
     * CHARGEN_REFLECTION
     * </p>
     * </li>
     * <li>
     * <p>
     * SSDP_REFLECTION
     * </p>
     * </li>
     * <li>
     * <p>
     * PORT_MAPPER
     * </p>
     * </li>
     * <li>
     * <p>
     * RIP_REFLECTION
     * </p>
     * </li>
     * <li>
     * <p>
     * SNMP_REFLECTION
     * </p>
     * </li>
     * <li>
     * <p>
     * MSSQL_REFLECTION
     * </p>
     * </li>
     * <li>
     * <p>
     * NET_BIOS_REFLECTION
     * </p>
     * </li>
     * <li>
     * <p>
     * SYN_FLOOD
     * </p>
     * </li>
     * <li>
     * <p>
     * ACK_FLOOD
     * </p>
     * </li>
     * <li>
     * <p>
     * REQUEST_FLOOD
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTP_REFLECTION
     * </p>
     * </li>
     * <li>
     * <p>
     * UDS_REFLECTION
     * </p>
     * </li>
     * <li>
     * <p>
     * MEMCACHED_REFLECTION
     * </p>
     * </li>
     * </ul>
     * 
     * @return The attack type. Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         UDP_TRAFFIC
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UDP_FRAGMENT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GENERIC_UDP_REFLECTION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DNS_REFLECTION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NTP_REFLECTION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CHARGEN_REFLECTION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSDP_REFLECTION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PORT_MAPPER
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RIP_REFLECTION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SNMP_REFLECTION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MSSQL_REFLECTION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NET_BIOS_REFLECTION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SYN_FLOOD
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACK_FLOOD
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REQUEST_FLOOD
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HTTP_REFLECTION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UDS_REFLECTION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMCACHED_REFLECTION
     *         </p>
     *         </li>
     */
    public final String vectorType() {
        return vectorType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vectorType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackVectorDescription)) {
            return false;
        }
        AttackVectorDescription other = (AttackVectorDescription) obj;
        return Objects.equals(vectorType(), other.vectorType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttackVectorDescription").add("VectorType", vectorType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VectorType":
            return Optional.ofNullable(clazz.cast(vectorType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttackVectorDescription, T> g) {
        return obj -> g.apply((AttackVectorDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttackVectorDescription> {
        /**
         * <p>
         * The attack type. Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * UDP_TRAFFIC
         * </p>
         * </li>
         * <li>
         * <p>
         * UDP_FRAGMENT
         * </p>
         * </li>
         * <li>
         * <p>
         * GENERIC_UDP_REFLECTION
         * </p>
         * </li>
         * <li>
         * <p>
         * DNS_REFLECTION
         * </p>
         * </li>
         * <li>
         * <p>
         * NTP_REFLECTION
         * </p>
         * </li>
         * <li>
         * <p>
         * CHARGEN_REFLECTION
         * </p>
         * </li>
         * <li>
         * <p>
         * SSDP_REFLECTION
         * </p>
         * </li>
         * <li>
         * <p>
         * PORT_MAPPER
         * </p>
         * </li>
         * <li>
         * <p>
         * RIP_REFLECTION
         * </p>
         * </li>
         * <li>
         * <p>
         * SNMP_REFLECTION
         * </p>
         * </li>
         * <li>
         * <p>
         * MSSQL_REFLECTION
         * </p>
         * </li>
         * <li>
         * <p>
         * NET_BIOS_REFLECTION
         * </p>
         * </li>
         * <li>
         * <p>
         * SYN_FLOOD
         * </p>
         * </li>
         * <li>
         * <p>
         * ACK_FLOOD
         * </p>
         * </li>
         * <li>
         * <p>
         * REQUEST_FLOOD
         * </p>
         * </li>
         * <li>
         * <p>
         * HTTP_REFLECTION
         * </p>
         * </li>
         * <li>
         * <p>
         * UDS_REFLECTION
         * </p>
         * </li>
         * <li>
         * <p>
         * MEMCACHED_REFLECTION
         * </p>
         * </li>
         * </ul>
         * 
         * @param vectorType
         *        The attack type. Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        UDP_TRAFFIC
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UDP_FRAGMENT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GENERIC_UDP_REFLECTION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DNS_REFLECTION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NTP_REFLECTION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CHARGEN_REFLECTION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SSDP_REFLECTION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PORT_MAPPER
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RIP_REFLECTION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SNMP_REFLECTION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MSSQL_REFLECTION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NET_BIOS_REFLECTION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SYN_FLOOD
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACK_FLOOD
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REQUEST_FLOOD
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HTTP_REFLECTION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UDS_REFLECTION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MEMCACHED_REFLECTION
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorType(String vectorType);
    }

    static final class BuilderImpl implements Builder {
        private String vectorType;

        private BuilderImpl() {
        }

        private BuilderImpl(AttackVectorDescription model) {
            vectorType(model.vectorType);
        }

        public final String getVectorType() {
            return vectorType;
        }

        public final void setVectorType(String vectorType) {
            this.vectorType = vectorType;
        }

        @Override
        public final Builder vectorType(String vectorType) {
            this.vectorType = vectorType;
            return this;
        }

        @Override
        public AttackVectorDescription build() {
            return new AttackVectorDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
