/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.AttackPropertiesCopier;
import software.amazon.awssdk.services.shield.model.AttackProperty;
import software.amazon.awssdk.services.shield.model.Mitigation;
import software.amazon.awssdk.services.shield.model.MitigationListCopier;
import software.amazon.awssdk.services.shield.model.SubResourceSummary;
import software.amazon.awssdk.services.shield.model.SubResourceSummaryListCopier;
import software.amazon.awssdk.services.shield.model.SummarizedCounter;
import software.amazon.awssdk.services.shield.model.SummarizedCounterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttackDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttackDetail> {
    private static final SdkField<String> ATTACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttackId").getter(AttackDetail.getter(AttackDetail::attackId)).setter(AttackDetail.setter(Builder::attackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(AttackDetail.getter(AttackDetail::resourceArn)).setter(AttackDetail.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<List<SubResourceSummary>> SUB_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubResources").getter(AttackDetail.getter(AttackDetail::subResources)).setter(AttackDetail.setter(Builder::subResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubResourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(AttackDetail.getter(AttackDetail::startTime)).setter(AttackDetail.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(AttackDetail.getter(AttackDetail::endTime)).setter(AttackDetail.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<List<SummarizedCounter>> ATTACK_COUNTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttackCounters").getter(AttackDetail.getter(AttackDetail::attackCounters)).setter(AttackDetail.setter(Builder::attackCounters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackCounters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SummarizedCounter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AttackProperty>> ATTACK_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttackProperties").getter(AttackDetail.getter(AttackDetail::attackProperties)).setter(AttackDetail.setter(Builder::attackProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttackProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Mitigation>> MITIGATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Mitigations").getter(AttackDetail.getter(AttackDetail::mitigations)).setter(AttackDetail.setter(Builder::mitigations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mitigations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Mitigation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACK_ID_FIELD, RESOURCE_ARN_FIELD, SUB_RESOURCES_FIELD, START_TIME_FIELD, END_TIME_FIELD, ATTACK_COUNTERS_FIELD, ATTACK_PROPERTIES_FIELD, MITIGATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attackId;
    private final String resourceArn;
    private final List<SubResourceSummary> subResources;
    private final Instant startTime;
    private final Instant endTime;
    private final List<SummarizedCounter> attackCounters;
    private final List<AttackProperty> attackProperties;
    private final List<Mitigation> mitigations;

    private AttackDetail(BuilderImpl builder) {
        this.attackId = builder.attackId;
        this.resourceArn = builder.resourceArn;
        this.subResources = builder.subResources;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.attackCounters = builder.attackCounters;
        this.attackProperties = builder.attackProperties;
        this.mitigations = builder.mitigations;
    }

    public final String attackId() {
        return this.attackId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final boolean hasSubResources() {
        return this.subResources != null && !(this.subResources instanceof SdkAutoConstructList);
    }

    public final List<SubResourceSummary> subResources() {
        return this.subResources;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasAttackCounters() {
        return this.attackCounters != null && !(this.attackCounters instanceof SdkAutoConstructList);
    }

    public final List<SummarizedCounter> attackCounters() {
        return this.attackCounters;
    }

    public final boolean hasAttackProperties() {
        return this.attackProperties != null && !(this.attackProperties instanceof SdkAutoConstructList);
    }

    public final List<AttackProperty> attackProperties() {
        return this.attackProperties;
    }

    public final boolean hasMitigations() {
        return this.mitigations != null && !(this.mitigations instanceof SdkAutoConstructList);
    }

    public final List<Mitigation> mitigations() {
        return this.mitigations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubResources() ? this.subResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttackCounters() ? this.attackCounters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttackProperties() ? this.attackProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMitigations() ? this.mitigations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackDetail)) {
            return false;
        }
        AttackDetail other = (AttackDetail)obj;
        return Objects.equals(this.attackId(), other.attackId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && this.hasSubResources() == other.hasSubResources() && Objects.equals(this.subResources(), other.subResources()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasAttackCounters() == other.hasAttackCounters() && Objects.equals(this.attackCounters(), other.attackCounters()) && this.hasAttackProperties() == other.hasAttackProperties() && Objects.equals(this.attackProperties(), other.attackProperties()) && this.hasMitigations() == other.hasMitigations() && Objects.equals(this.mitigations(), other.mitigations());
    }

    public final String toString() {
        return ToString.builder((String)"AttackDetail").add("AttackId", (Object)this.attackId()).add("ResourceArn", (Object)this.resourceArn()).add("SubResources", this.hasSubResources() ? this.subResources() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("AttackCounters", this.hasAttackCounters() ? this.attackCounters() : null).add("AttackProperties", this.hasAttackProperties() ? this.attackProperties() : null).add("Mitigations", this.hasMitigations() ? this.mitigations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttackId": {
                return Optional.ofNullable(clazz.cast(this.attackId()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "SubResources": {
                return Optional.ofNullable(clazz.cast(this.subResources()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "AttackCounters": {
                return Optional.ofNullable(clazz.cast(this.attackCounters()));
            }
            case "AttackProperties": {
                return Optional.ofNullable(clazz.cast(this.attackProperties()));
            }
            case "Mitigations": {
                return Optional.ofNullable(clazz.cast(this.mitigations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttackDetail, T> g) {
        return obj -> g.apply((AttackDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attackId;
        private String resourceArn;
        private List<SubResourceSummary> subResources = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;
        private List<SummarizedCounter> attackCounters = DefaultSdkAutoConstructList.getInstance();
        private List<AttackProperty> attackProperties = DefaultSdkAutoConstructList.getInstance();
        private List<Mitigation> mitigations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttackDetail model) {
            this.attackId(model.attackId);
            this.resourceArn(model.resourceArn);
            this.subResources(model.subResources);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.attackCounters(model.attackCounters);
            this.attackProperties(model.attackProperties);
            this.mitigations(model.mitigations);
        }

        public final String getAttackId() {
            return this.attackId;
        }

        public final void setAttackId(String attackId) {
            this.attackId = attackId;
        }

        @Override
        @Transient
        public final Builder attackId(String attackId) {
            this.attackId = attackId;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final List<SubResourceSummary.Builder> getSubResources() {
            List<SubResourceSummary.Builder> result = SubResourceSummaryListCopier.copyToBuilder(this.subResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubResources(Collection<SubResourceSummary.BuilderImpl> subResources) {
            this.subResources = SubResourceSummaryListCopier.copyFromBuilder(subResources);
        }

        @Override
        @Transient
        public final Builder subResources(Collection<SubResourceSummary> subResources) {
            this.subResources = SubResourceSummaryListCopier.copy(subResources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subResources(SubResourceSummary ... subResources) {
            this.subResources(Arrays.asList(subResources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subResources(Consumer<SubResourceSummary.Builder> ... subResources) {
            this.subResources(Stream.of(subResources).map(c -> (SubResourceSummary)((SubResourceSummary.Builder)SubResourceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<SummarizedCounter.Builder> getAttackCounters() {
            List<SummarizedCounter.Builder> result = SummarizedCounterListCopier.copyToBuilder(this.attackCounters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttackCounters(Collection<SummarizedCounter.BuilderImpl> attackCounters) {
            this.attackCounters = SummarizedCounterListCopier.copyFromBuilder(attackCounters);
        }

        @Override
        @Transient
        public final Builder attackCounters(Collection<SummarizedCounter> attackCounters) {
            this.attackCounters = SummarizedCounterListCopier.copy(attackCounters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attackCounters(SummarizedCounter ... attackCounters) {
            this.attackCounters(Arrays.asList(attackCounters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attackCounters(Consumer<SummarizedCounter.Builder> ... attackCounters) {
            this.attackCounters(Stream.of(attackCounters).map(c -> (SummarizedCounter)((SummarizedCounter.Builder)SummarizedCounter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AttackProperty.Builder> getAttackProperties() {
            List<AttackProperty.Builder> result = AttackPropertiesCopier.copyToBuilder(this.attackProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttackProperties(Collection<AttackProperty.BuilderImpl> attackProperties) {
            this.attackProperties = AttackPropertiesCopier.copyFromBuilder(attackProperties);
        }

        @Override
        @Transient
        public final Builder attackProperties(Collection<AttackProperty> attackProperties) {
            this.attackProperties = AttackPropertiesCopier.copy(attackProperties);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attackProperties(AttackProperty ... attackProperties) {
            this.attackProperties(Arrays.asList(attackProperties));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attackProperties(Consumer<AttackProperty.Builder> ... attackProperties) {
            this.attackProperties(Stream.of(attackProperties).map(c -> (AttackProperty)((AttackProperty.Builder)AttackProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Mitigation.Builder> getMitigations() {
            List<Mitigation.Builder> result = MitigationListCopier.copyToBuilder(this.mitigations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMitigations(Collection<Mitigation.BuilderImpl> mitigations) {
            this.mitigations = MitigationListCopier.copyFromBuilder(mitigations);
        }

        @Override
        @Transient
        public final Builder mitigations(Collection<Mitigation> mitigations) {
            this.mitigations = MitigationListCopier.copy(mitigations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mitigations(Mitigation ... mitigations) {
            this.mitigations(Arrays.asList(mitigations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mitigations(Consumer<Mitigation.Builder> ... mitigations) {
            this.mitigations(Stream.of(mitigations).map(c -> (Mitigation)((Mitigation.Builder)Mitigation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AttackDetail build() {
            return new AttackDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttackDetail> {
        public Builder attackId(String var1);

        public Builder resourceArn(String var1);

        public Builder subResources(Collection<SubResourceSummary> var1);

        public Builder subResources(SubResourceSummary ... var1);

        public Builder subResources(Consumer<SubResourceSummary.Builder> ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder attackCounters(Collection<SummarizedCounter> var1);

        public Builder attackCounters(SummarizedCounter ... var1);

        public Builder attackCounters(Consumer<SummarizedCounter.Builder> ... var1);

        public Builder attackProperties(Collection<AttackProperty> var1);

        public Builder attackProperties(AttackProperty ... var1);

        public Builder attackProperties(Consumer<AttackProperty.Builder> ... var1);

        public Builder mitigations(Collection<Mitigation> var1);

        public Builder mitigations(Mitigation ... var1);

        public Builder mitigations(Consumer<Mitigation.Builder> ... var1);
    }
}

