/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.AutoRenew;
import software.amazon.awssdk.services.shield.model.Limit;
import software.amazon.awssdk.services.shield.model.LimitsCopier;
import software.amazon.awssdk.services.shield.model.ProactiveEngagementStatus;
import software.amazon.awssdk.services.shield.model.SubscriptionLimits;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subscription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Subscription> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(Subscription.getter(Subscription::startTime)).setter(Subscription.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(Subscription.getter(Subscription::endTime)).setter(Subscription.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Long> TIME_COMMITMENT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TimeCommitmentInSeconds").getter(Subscription.getter(Subscription::timeCommitmentInSeconds)).setter(Subscription.setter(Builder::timeCommitmentInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeCommitmentInSeconds").build()}).build();
    private static final SdkField<String> AUTO_RENEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoRenew").getter(Subscription.getter(Subscription::autoRenewAsString)).setter(Subscription.setter(Builder::autoRenew)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRenew").build()}).build();
    private static final SdkField<List<Limit>> LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Limits").getter(Subscription.getter(Subscription::limits)).setter(Subscription.setter(Builder::limits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Limit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROACTIVE_ENGAGEMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProactiveEngagementStatus").getter(Subscription.getter(Subscription::proactiveEngagementStatusAsString)).setter(Subscription.setter(Builder::proactiveEngagementStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProactiveEngagementStatus").build()}).build();
    private static final SdkField<SubscriptionLimits> SUBSCRIPTION_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SubscriptionLimits").getter(Subscription.getter(Subscription::subscriptionLimits)).setter(Subscription.setter(Builder::subscriptionLimits)).constructor(SubscriptionLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionLimits").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionArn").getter(Subscription.getter(Subscription::subscriptionArn)).setter(Subscription.setter(Builder::subscriptionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, TIME_COMMITMENT_IN_SECONDS_FIELD, AUTO_RENEW_FIELD, LIMITS_FIELD, PROACTIVE_ENGAGEMENT_STATUS_FIELD, SUBSCRIPTION_LIMITS_FIELD, SUBSCRIPTION_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant startTime;
    private final Instant endTime;
    private final Long timeCommitmentInSeconds;
    private final String autoRenew;
    private final List<Limit> limits;
    private final String proactiveEngagementStatus;
    private final SubscriptionLimits subscriptionLimits;
    private final String subscriptionArn;

    private Subscription(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.timeCommitmentInSeconds = builder.timeCommitmentInSeconds;
        this.autoRenew = builder.autoRenew;
        this.limits = builder.limits;
        this.proactiveEngagementStatus = builder.proactiveEngagementStatus;
        this.subscriptionLimits = builder.subscriptionLimits;
        this.subscriptionArn = builder.subscriptionArn;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Long timeCommitmentInSeconds() {
        return this.timeCommitmentInSeconds;
    }

    public final AutoRenew autoRenew() {
        return AutoRenew.fromValue(this.autoRenew);
    }

    public final String autoRenewAsString() {
        return this.autoRenew;
    }

    public final boolean hasLimits() {
        return this.limits != null && !(this.limits instanceof SdkAutoConstructList);
    }

    public final List<Limit> limits() {
        return this.limits;
    }

    public final ProactiveEngagementStatus proactiveEngagementStatus() {
        return ProactiveEngagementStatus.fromValue(this.proactiveEngagementStatus);
    }

    public final String proactiveEngagementStatusAsString() {
        return this.proactiveEngagementStatus;
    }

    public final SubscriptionLimits subscriptionLimits() {
        return this.subscriptionLimits;
    }

    public final String subscriptionArn() {
        return this.subscriptionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeCommitmentInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRenewAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLimits() ? this.limits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.proactiveEngagementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionLimits());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.timeCommitmentInSeconds(), other.timeCommitmentInSeconds()) && Objects.equals(this.autoRenewAsString(), other.autoRenewAsString()) && this.hasLimits() == other.hasLimits() && Objects.equals(this.limits(), other.limits()) && Objects.equals(this.proactiveEngagementStatusAsString(), other.proactiveEngagementStatusAsString()) && Objects.equals(this.subscriptionLimits(), other.subscriptionLimits()) && Objects.equals(this.subscriptionArn(), other.subscriptionArn());
    }

    public final String toString() {
        return ToString.builder((String)"Subscription").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("TimeCommitmentInSeconds", (Object)this.timeCommitmentInSeconds()).add("AutoRenew", (Object)this.autoRenewAsString()).add("Limits", this.hasLimits() ? this.limits() : null).add("ProactiveEngagementStatus", (Object)this.proactiveEngagementStatusAsString()).add("SubscriptionLimits", (Object)this.subscriptionLimits()).add("SubscriptionArn", (Object)this.subscriptionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "TimeCommitmentInSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeCommitmentInSeconds()));
            }
            case "AutoRenew": {
                return Optional.ofNullable(clazz.cast(this.autoRenewAsString()));
            }
            case "Limits": {
                return Optional.ofNullable(clazz.cast(this.limits()));
            }
            case "ProactiveEngagementStatus": {
                return Optional.ofNullable(clazz.cast(this.proactiveEngagementStatusAsString()));
            }
            case "SubscriptionLimits": {
                return Optional.ofNullable(clazz.cast(this.subscriptionLimits()));
            }
            case "SubscriptionArn": {
                return Optional.ofNullable(clazz.cast(this.subscriptionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Subscription, T> g) {
        return obj -> g.apply((Subscription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private Long timeCommitmentInSeconds;
        private String autoRenew;
        private List<Limit> limits = DefaultSdkAutoConstructList.getInstance();
        private String proactiveEngagementStatus;
        private SubscriptionLimits subscriptionLimits;
        private String subscriptionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.timeCommitmentInSeconds(model.timeCommitmentInSeconds);
            this.autoRenew(model.autoRenew);
            this.limits(model.limits);
            this.proactiveEngagementStatus(model.proactiveEngagementStatus);
            this.subscriptionLimits(model.subscriptionLimits);
            this.subscriptionArn(model.subscriptionArn);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Long getTimeCommitmentInSeconds() {
            return this.timeCommitmentInSeconds;
        }

        @Override
        public final Builder timeCommitmentInSeconds(Long timeCommitmentInSeconds) {
            this.timeCommitmentInSeconds = timeCommitmentInSeconds;
            return this;
        }

        public final void setTimeCommitmentInSeconds(Long timeCommitmentInSeconds) {
            this.timeCommitmentInSeconds = timeCommitmentInSeconds;
        }

        public final String getAutoRenew() {
            return this.autoRenew;
        }

        @Override
        public final Builder autoRenew(String autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        @Override
        public final Builder autoRenew(AutoRenew autoRenew) {
            this.autoRenew(autoRenew == null ? null : autoRenew.toString());
            return this;
        }

        public final void setAutoRenew(String autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final Collection<Limit.Builder> getLimits() {
            if (this.limits instanceof SdkAutoConstructList) {
                return null;
            }
            return this.limits != null ? (Collection)this.limits.stream().map(Limit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder limits(Collection<Limit> limits) {
            this.limits = LimitsCopier.copy(limits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limits(Limit ... limits) {
            this.limits(Arrays.asList(limits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limits(Consumer<Limit.Builder> ... limits) {
            this.limits(Stream.of(limits).map(c -> (Limit)((Limit.Builder)Limit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLimits(Collection<Limit.BuilderImpl> limits) {
            this.limits = LimitsCopier.copyFromBuilder(limits);
        }

        public final String getProactiveEngagementStatus() {
            return this.proactiveEngagementStatus;
        }

        @Override
        public final Builder proactiveEngagementStatus(String proactiveEngagementStatus) {
            this.proactiveEngagementStatus = proactiveEngagementStatus;
            return this;
        }

        @Override
        public final Builder proactiveEngagementStatus(ProactiveEngagementStatus proactiveEngagementStatus) {
            this.proactiveEngagementStatus(proactiveEngagementStatus == null ? null : proactiveEngagementStatus.toString());
            return this;
        }

        public final void setProactiveEngagementStatus(String proactiveEngagementStatus) {
            this.proactiveEngagementStatus = proactiveEngagementStatus;
        }

        public final SubscriptionLimits.Builder getSubscriptionLimits() {
            return this.subscriptionLimits != null ? this.subscriptionLimits.toBuilder() : null;
        }

        @Override
        public final Builder subscriptionLimits(SubscriptionLimits subscriptionLimits) {
            this.subscriptionLimits = subscriptionLimits;
            return this;
        }

        public final void setSubscriptionLimits(SubscriptionLimits.BuilderImpl subscriptionLimits) {
            this.subscriptionLimits = subscriptionLimits != null ? subscriptionLimits.build() : null;
        }

        public final String getSubscriptionArn() {
            return this.subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        public Subscription build() {
            return new Subscription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Subscription> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder timeCommitmentInSeconds(Long var1);

        public Builder autoRenew(String var1);

        public Builder autoRenew(AutoRenew var1);

        public Builder limits(Collection<Limit> var1);

        public Builder limits(Limit ... var1);

        public Builder limits(Consumer<Limit.Builder> ... var1);

        public Builder proactiveEngagementStatus(String var1);

        public Builder proactiveEngagementStatus(ProactiveEngagementStatus var1);

        public Builder subscriptionLimits(SubscriptionLimits var1);

        default public Builder subscriptionLimits(Consumer<SubscriptionLimits.Builder> subscriptionLimits) {
            return this.subscriptionLimits((SubscriptionLimits)((SubscriptionLimits.Builder)SubscriptionLimits.builder().applyMutation(subscriptionLimits)).build());
        }

        public Builder subscriptionArn(String var1);
    }
}

