/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAttackStatisticsResponse extends ShieldResponse implements
        ToCopyableBuilder<DescribeAttackStatisticsResponse.Builder, DescribeAttackStatisticsResponse> {
    private static final SdkField<TimeRange> TIME_RANGE_FIELD = SdkField.<TimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("TimeRange").getter(getter(DescribeAttackStatisticsResponse::timeRange))
            .setter(setter(Builder::timeRange)).constructor(TimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRange").build()).build();

    private static final SdkField<List<AttackStatisticsDataItem>> DATA_ITEMS_FIELD = SdkField
            .<List<AttackStatisticsDataItem>> builder(MarshallingType.LIST)
            .memberName("DataItems")
            .getter(getter(DescribeAttackStatisticsResponse::dataItems))
            .setter(setter(Builder::dataItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttackStatisticsDataItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttackStatisticsDataItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_RANGE_FIELD,
            DATA_ITEMS_FIELD));

    private final TimeRange timeRange;

    private final List<AttackStatisticsDataItem> dataItems;

    private DescribeAttackStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.timeRange = builder.timeRange;
        this.dataItems = builder.dataItems;
    }

    /**
     * Returns the value of the TimeRange property for this object.
     * 
     * @return The value of the TimeRange property for this object.
     */
    public final TimeRange timeRange() {
        return timeRange;
    }

    /**
     * Returns true if the DataItems property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDataItems() {
        return dataItems != null && !(dataItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data that describes the attacks detected during the time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDataItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The data that describes the attacks detected during the time period.
     */
    public final List<AttackStatisticsDataItem> dataItems() {
        return dataItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(timeRange());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataItems() ? dataItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAttackStatisticsResponse)) {
            return false;
        }
        DescribeAttackStatisticsResponse other = (DescribeAttackStatisticsResponse) obj;
        return Objects.equals(timeRange(), other.timeRange()) && hasDataItems() == other.hasDataItems()
                && Objects.equals(dataItems(), other.dataItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAttackStatisticsResponse").add("TimeRange", timeRange())
                .add("DataItems", hasDataItems() ? dataItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeRange":
            return Optional.ofNullable(clazz.cast(timeRange()));
        case "DataItems":
            return Optional.ofNullable(clazz.cast(dataItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAttackStatisticsResponse, T> g) {
        return obj -> g.apply((DescribeAttackStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ShieldResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAttackStatisticsResponse> {
        /**
         * Sets the value of the TimeRange property for this object.
         *
         * @param timeRange
         *        The new value for the TimeRange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRange(TimeRange timeRange);

        /**
         * Sets the value of the TimeRange property for this object.
         *
         * This is a convenience that creates an instance of the {@link TimeRange.Builder} avoiding the need to create
         * one manually via {@link TimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeRange.Builder#build()} is called immediately and its result
         * is passed to {@link #timeRange(TimeRange)}.
         * 
         * @param timeRange
         *        a consumer that will call methods on {@link TimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRange(TimeRange)
         */
        default Builder timeRange(Consumer<TimeRange.Builder> timeRange) {
            return timeRange(TimeRange.builder().applyMutation(timeRange).build());
        }

        /**
         * <p>
         * The data that describes the attacks detected during the time period.
         * </p>
         * 
         * @param dataItems
         *        The data that describes the attacks detected during the time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataItems(Collection<AttackStatisticsDataItem> dataItems);

        /**
         * <p>
         * The data that describes the attacks detected during the time period.
         * </p>
         * 
         * @param dataItems
         *        The data that describes the attacks detected during the time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataItems(AttackStatisticsDataItem... dataItems);

        /**
         * <p>
         * The data that describes the attacks detected during the time period.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttackStatisticsDataItem>.Builder} avoiding
         * the need to create one manually via {@link List<AttackStatisticsDataItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttackStatisticsDataItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #dataItems(List<AttackStatisticsDataItem>)}.
         * 
         * @param dataItems
         *        a consumer that will call methods on {@link List<AttackStatisticsDataItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataItems(List<AttackStatisticsDataItem>)
         */
        Builder dataItems(Consumer<AttackStatisticsDataItem.Builder>... dataItems);
    }

    static final class BuilderImpl extends ShieldResponse.BuilderImpl implements Builder {
        private TimeRange timeRange;

        private List<AttackStatisticsDataItem> dataItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAttackStatisticsResponse model) {
            super(model);
            timeRange(model.timeRange);
            dataItems(model.dataItems);
        }

        public final TimeRange.Builder getTimeRange() {
            return timeRange != null ? timeRange.toBuilder() : null;
        }

        @Override
        public final Builder timeRange(TimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public final void setTimeRange(TimeRange.BuilderImpl timeRange) {
            this.timeRange = timeRange != null ? timeRange.build() : null;
        }

        public final Collection<AttackStatisticsDataItem.Builder> getDataItems() {
            if (dataItems instanceof SdkAutoConstructList) {
                return null;
            }
            return dataItems != null ? dataItems.stream().map(AttackStatisticsDataItem::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder dataItems(Collection<AttackStatisticsDataItem> dataItems) {
            this.dataItems = AttackStatisticsDataListCopier.copy(dataItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataItems(AttackStatisticsDataItem... dataItems) {
            dataItems(Arrays.asList(dataItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataItems(Consumer<AttackStatisticsDataItem.Builder>... dataItems) {
            dataItems(Stream.of(dataItems).map(c -> AttackStatisticsDataItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDataItems(Collection<AttackStatisticsDataItem.BuilderImpl> dataItems) {
            this.dataItems = AttackStatisticsDataListCopier.copyFromBuilder(dataItems);
        }

        @Override
        public DescribeAttackStatisticsResponse build() {
            return new DescribeAttackStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
