/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a DDoS attack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttackDetail implements SdkPojo, Serializable, ToCopyableBuilder<AttackDetail.Builder, AttackDetail> {
    private static final SdkField<String> ATTACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttackId").getter(getter(AttackDetail::attackId)).setter(setter(Builder::attackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackId").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(AttackDetail::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<List<SubResourceSummary>> SUB_RESOURCES_FIELD = SdkField
            .<List<SubResourceSummary>> builder(MarshallingType.LIST)
            .memberName("SubResources")
            .getter(getter(AttackDetail::subResources))
            .setter(setter(Builder::subResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubResourceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubResourceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(AttackDetail::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(AttackDetail::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<List<SummarizedCounter>> ATTACK_COUNTERS_FIELD = SdkField
            .<List<SummarizedCounter>> builder(MarshallingType.LIST)
            .memberName("AttackCounters")
            .getter(getter(AttackDetail::attackCounters))
            .setter(setter(Builder::attackCounters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackCounters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SummarizedCounter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SummarizedCounter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AttackProperty>> ATTACK_PROPERTIES_FIELD = SdkField
            .<List<AttackProperty>> builder(MarshallingType.LIST)
            .memberName("AttackProperties")
            .getter(getter(AttackDetail::attackProperties))
            .setter(setter(Builder::attackProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttackProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttackProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Mitigation>> MITIGATIONS_FIELD = SdkField
            .<List<Mitigation>> builder(MarshallingType.LIST)
            .memberName("Mitigations")
            .getter(getter(AttackDetail::mitigations))
            .setter(setter(Builder::mitigations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mitigations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Mitigation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Mitigation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACK_ID_FIELD,
            RESOURCE_ARN_FIELD, SUB_RESOURCES_FIELD, START_TIME_FIELD, END_TIME_FIELD, ATTACK_COUNTERS_FIELD,
            ATTACK_PROPERTIES_FIELD, MITIGATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attackId;

    private final String resourceArn;

    private final List<SubResourceSummary> subResources;

    private final Instant startTime;

    private final Instant endTime;

    private final List<SummarizedCounter> attackCounters;

    private final List<AttackProperty> attackProperties;

    private final List<Mitigation> mitigations;

    private AttackDetail(BuilderImpl builder) {
        this.attackId = builder.attackId;
        this.resourceArn = builder.resourceArn;
        this.subResources = builder.subResources;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.attackCounters = builder.attackCounters;
        this.attackProperties = builder.attackProperties;
        this.mitigations = builder.mitigations;
    }

    /**
     * <p>
     * The unique identifier (ID) of the attack.
     * </p>
     * 
     * @return The unique identifier (ID) of the attack.
     */
    public final String attackId() {
        return attackId;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the resource that was attacked.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the resource that was attacked.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * Returns true if the SubResources property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSubResources() {
        return subResources != null && !(subResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If applicable, additional detail about the resource being attacked, for example, IP address or URL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubResources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return If applicable, additional detail about the resource being attacked, for example, IP address or URL.
     */
    public final List<SubResourceSummary> subResources() {
        return subResources;
    }

    /**
     * <p>
     * The time the attack started, in Unix time in seconds. For more information see <a
     * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.
     * </p>
     * 
     * @return The time the attack started, in Unix time in seconds. For more information see <a
     *         href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types"
     *         >timestamp</a>.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time the attack ended, in Unix time in seconds. For more information see <a
     * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.
     * </p>
     * 
     * @return The time the attack ended, in Unix time in seconds. For more information see <a
     *         href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types"
     *         >timestamp</a>.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * Returns true if the AttackCounters property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttackCounters() {
        return attackCounters != null && !(attackCounters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of counters that describe the attack for the specified time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttackCounters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of counters that describe the attack for the specified time period.
     */
    public final List<SummarizedCounter> attackCounters() {
        return attackCounters;
    }

    /**
     * Returns true if the AttackProperties property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAttackProperties() {
        return attackProperties != null && !(attackProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of <a>AttackProperty</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttackProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The array of <a>AttackProperty</a> objects.
     */
    public final List<AttackProperty> attackProperties() {
        return attackProperties;
    }

    /**
     * Returns true if the Mitigations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMitigations() {
        return mitigations != null && !(mitigations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of mitigation actions taken for the attack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMitigations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of mitigation actions taken for the attack.
     */
    public final List<Mitigation> mitigations() {
        return mitigations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attackId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubResources() ? subResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttackCounters() ? attackCounters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttackProperties() ? attackProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMitigations() ? mitigations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackDetail)) {
            return false;
        }
        AttackDetail other = (AttackDetail) obj;
        return Objects.equals(attackId(), other.attackId()) && Objects.equals(resourceArn(), other.resourceArn())
                && hasSubResources() == other.hasSubResources() && Objects.equals(subResources(), other.subResources())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && hasAttackCounters() == other.hasAttackCounters() && Objects.equals(attackCounters(), other.attackCounters())
                && hasAttackProperties() == other.hasAttackProperties()
                && Objects.equals(attackProperties(), other.attackProperties()) && hasMitigations() == other.hasMitigations()
                && Objects.equals(mitigations(), other.mitigations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttackDetail").add("AttackId", attackId()).add("ResourceArn", resourceArn())
                .add("SubResources", hasSubResources() ? subResources() : null).add("StartTime", startTime())
                .add("EndTime", endTime()).add("AttackCounters", hasAttackCounters() ? attackCounters() : null)
                .add("AttackProperties", hasAttackProperties() ? attackProperties() : null)
                .add("Mitigations", hasMitigations() ? mitigations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttackId":
            return Optional.ofNullable(clazz.cast(attackId()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "SubResources":
            return Optional.ofNullable(clazz.cast(subResources()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "AttackCounters":
            return Optional.ofNullable(clazz.cast(attackCounters()));
        case "AttackProperties":
            return Optional.ofNullable(clazz.cast(attackProperties()));
        case "Mitigations":
            return Optional.ofNullable(clazz.cast(mitigations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttackDetail, T> g) {
        return obj -> g.apply((AttackDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttackDetail> {
        /**
         * <p>
         * The unique identifier (ID) of the attack.
         * </p>
         * 
         * @param attackId
         *        The unique identifier (ID) of the attack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackId(String attackId);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the resource that was attacked.
         * </p>
         * 
         * @param resourceArn
         *        The ARN (Amazon Resource Name) of the resource that was attacked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * If applicable, additional detail about the resource being attacked, for example, IP address or URL.
         * </p>
         * 
         * @param subResources
         *        If applicable, additional detail about the resource being attacked, for example, IP address or URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subResources(Collection<SubResourceSummary> subResources);

        /**
         * <p>
         * If applicable, additional detail about the resource being attacked, for example, IP address or URL.
         * </p>
         * 
         * @param subResources
         *        If applicable, additional detail about the resource being attacked, for example, IP address or URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subResources(SubResourceSummary... subResources);

        /**
         * <p>
         * If applicable, additional detail about the resource being attacked, for example, IP address or URL.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SubResourceSummary>.Builder} avoiding the
         * need to create one manually via {@link List<SubResourceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SubResourceSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #subResources(List<SubResourceSummary>)}.
         * 
         * @param subResources
         *        a consumer that will call methods on {@link List<SubResourceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subResources(List<SubResourceSummary>)
         */
        Builder subResources(Consumer<SubResourceSummary.Builder>... subResources);

        /**
         * <p>
         * The time the attack started, in Unix time in seconds. For more information see <a
         * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.
         * </p>
         * 
         * @param startTime
         *        The time the attack started, in Unix time in seconds. For more information see <a
         *        href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types"
         *        >timestamp</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time the attack ended, in Unix time in seconds. For more information see <a
         * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.
         * </p>
         * 
         * @param endTime
         *        The time the attack ended, in Unix time in seconds. For more information see <a
         *        href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types"
         *        >timestamp</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * List of counters that describe the attack for the specified time period.
         * </p>
         * 
         * @param attackCounters
         *        List of counters that describe the attack for the specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackCounters(Collection<SummarizedCounter> attackCounters);

        /**
         * <p>
         * List of counters that describe the attack for the specified time period.
         * </p>
         * 
         * @param attackCounters
         *        List of counters that describe the attack for the specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackCounters(SummarizedCounter... attackCounters);

        /**
         * <p>
         * List of counters that describe the attack for the specified time period.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SummarizedCounter>.Builder} avoiding the
         * need to create one manually via {@link List<SummarizedCounter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SummarizedCounter>.Builder#build()} is called immediately
         * and its result is passed to {@link #attackCounters(List<SummarizedCounter>)}.
         * 
         * @param attackCounters
         *        a consumer that will call methods on {@link List<SummarizedCounter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attackCounters(List<SummarizedCounter>)
         */
        Builder attackCounters(Consumer<SummarizedCounter.Builder>... attackCounters);

        /**
         * <p>
         * The array of <a>AttackProperty</a> objects.
         * </p>
         * 
         * @param attackProperties
         *        The array of <a>AttackProperty</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackProperties(Collection<AttackProperty> attackProperties);

        /**
         * <p>
         * The array of <a>AttackProperty</a> objects.
         * </p>
         * 
         * @param attackProperties
         *        The array of <a>AttackProperty</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackProperties(AttackProperty... attackProperties);

        /**
         * <p>
         * The array of <a>AttackProperty</a> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttackProperty>.Builder} avoiding the need
         * to create one manually via {@link List<AttackProperty>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttackProperty>.Builder#build()} is called immediately and
         * its result is passed to {@link #attackProperties(List<AttackProperty>)}.
         * 
         * @param attackProperties
         *        a consumer that will call methods on {@link List<AttackProperty>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attackProperties(List<AttackProperty>)
         */
        Builder attackProperties(Consumer<AttackProperty.Builder>... attackProperties);

        /**
         * <p>
         * List of mitigation actions taken for the attack.
         * </p>
         * 
         * @param mitigations
         *        List of mitigation actions taken for the attack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mitigations(Collection<Mitigation> mitigations);

        /**
         * <p>
         * List of mitigation actions taken for the attack.
         * </p>
         * 
         * @param mitigations
         *        List of mitigation actions taken for the attack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mitigations(Mitigation... mitigations);

        /**
         * <p>
         * List of mitigation actions taken for the attack.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Mitigation>.Builder} avoiding the need to
         * create one manually via {@link List<Mitigation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Mitigation>.Builder#build()} is called immediately and its
         * result is passed to {@link #mitigations(List<Mitigation>)}.
         * 
         * @param mitigations
         *        a consumer that will call methods on {@link List<Mitigation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mitigations(List<Mitigation>)
         */
        Builder mitigations(Consumer<Mitigation.Builder>... mitigations);
    }

    static final class BuilderImpl implements Builder {
        private String attackId;

        private String resourceArn;

        private List<SubResourceSummary> subResources = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private List<SummarizedCounter> attackCounters = DefaultSdkAutoConstructList.getInstance();

        private List<AttackProperty> attackProperties = DefaultSdkAutoConstructList.getInstance();

        private List<Mitigation> mitigations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttackDetail model) {
            attackId(model.attackId);
            resourceArn(model.resourceArn);
            subResources(model.subResources);
            startTime(model.startTime);
            endTime(model.endTime);
            attackCounters(model.attackCounters);
            attackProperties(model.attackProperties);
            mitigations(model.mitigations);
        }

        public final String getAttackId() {
            return attackId;
        }

        @Override
        public final Builder attackId(String attackId) {
            this.attackId = attackId;
            return this;
        }

        public final void setAttackId(String attackId) {
            this.attackId = attackId;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<SubResourceSummary.Builder> getSubResources() {
            if (subResources instanceof SdkAutoConstructList) {
                return null;
            }
            return subResources != null ? subResources.stream().map(SubResourceSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder subResources(Collection<SubResourceSummary> subResources) {
            this.subResources = SubResourceSummaryListCopier.copy(subResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subResources(SubResourceSummary... subResources) {
            subResources(Arrays.asList(subResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subResources(Consumer<SubResourceSummary.Builder>... subResources) {
            subResources(Stream.of(subResources).map(c -> SubResourceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSubResources(Collection<SubResourceSummary.BuilderImpl> subResources) {
            this.subResources = SubResourceSummaryListCopier.copyFromBuilder(subResources);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<SummarizedCounter.Builder> getAttackCounters() {
            if (attackCounters instanceof SdkAutoConstructList) {
                return null;
            }
            return attackCounters != null ? attackCounters.stream().map(SummarizedCounter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attackCounters(Collection<SummarizedCounter> attackCounters) {
            this.attackCounters = SummarizedCounterListCopier.copy(attackCounters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackCounters(SummarizedCounter... attackCounters) {
            attackCounters(Arrays.asList(attackCounters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackCounters(Consumer<SummarizedCounter.Builder>... attackCounters) {
            attackCounters(Stream.of(attackCounters).map(c -> SummarizedCounter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttackCounters(Collection<SummarizedCounter.BuilderImpl> attackCounters) {
            this.attackCounters = SummarizedCounterListCopier.copyFromBuilder(attackCounters);
        }

        public final Collection<AttackProperty.Builder> getAttackProperties() {
            if (attackProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return attackProperties != null ? attackProperties.stream().map(AttackProperty::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attackProperties(Collection<AttackProperty> attackProperties) {
            this.attackProperties = AttackPropertiesCopier.copy(attackProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackProperties(AttackProperty... attackProperties) {
            attackProperties(Arrays.asList(attackProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackProperties(Consumer<AttackProperty.Builder>... attackProperties) {
            attackProperties(Stream.of(attackProperties).map(c -> AttackProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttackProperties(Collection<AttackProperty.BuilderImpl> attackProperties) {
            this.attackProperties = AttackPropertiesCopier.copyFromBuilder(attackProperties);
        }

        public final Collection<Mitigation.Builder> getMitigations() {
            if (mitigations instanceof SdkAutoConstructList) {
                return null;
            }
            return mitigations != null ? mitigations.stream().map(Mitigation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mitigations(Collection<Mitigation> mitigations) {
            this.mitigations = MitigationListCopier.copy(mitigations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mitigations(Mitigation... mitigations) {
            mitigations(Arrays.asList(mitigations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mitigations(Consumer<Mitigation.Builder>... mitigations) {
            mitigations(Stream.of(mitigations).map(c -> Mitigation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMitigations(Collection<Mitigation.BuilderImpl> mitigations) {
            this.mitigations = MitigationListCopier.copyFromBuilder(mitigations);
        }

        @Override
        public AttackDetail build() {
            return new AttackDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
