/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.AttackVectorDescription;
import software.amazon.awssdk.services.shield.model.AttackVectorDescriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttackSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttackSummary> {
    private static final SdkField<String> ATTACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttackId").getter(AttackSummary.getter(AttackSummary::attackId)).setter(AttackSummary.setter(Builder::attackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(AttackSummary.getter(AttackSummary::resourceArn)).setter(AttackSummary.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(AttackSummary.getter(AttackSummary::startTime)).setter(AttackSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(AttackSummary.getter(AttackSummary::endTime)).setter(AttackSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<List<AttackVectorDescription>> ATTACK_VECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttackVectors").getter(AttackSummary.getter(AttackSummary::attackVectors)).setter(AttackSummary.setter(Builder::attackVectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackVectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttackVectorDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACK_ID_FIELD, RESOURCE_ARN_FIELD, START_TIME_FIELD, END_TIME_FIELD, ATTACK_VECTORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attackId;
    private final String resourceArn;
    private final Instant startTime;
    private final Instant endTime;
    private final List<AttackVectorDescription> attackVectors;

    private AttackSummary(BuilderImpl builder) {
        this.attackId = builder.attackId;
        this.resourceArn = builder.resourceArn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.attackVectors = builder.attackVectors;
    }

    public final String attackId() {
        return this.attackId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasAttackVectors() {
        return this.attackVectors != null && !(this.attackVectors instanceof SdkAutoConstructList);
    }

    public final List<AttackVectorDescription> attackVectors() {
        return this.attackVectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttackVectors() ? this.attackVectors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackSummary)) {
            return false;
        }
        AttackSummary other = (AttackSummary)obj;
        return Objects.equals(this.attackId(), other.attackId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasAttackVectors() == other.hasAttackVectors() && Objects.equals(this.attackVectors(), other.attackVectors());
    }

    public final String toString() {
        return ToString.builder((String)"AttackSummary").add("AttackId", (Object)this.attackId()).add("ResourceArn", (Object)this.resourceArn()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("AttackVectors", this.hasAttackVectors() ? this.attackVectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttackId": {
                return Optional.ofNullable(clazz.cast(this.attackId()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "AttackVectors": {
                return Optional.ofNullable(clazz.cast(this.attackVectors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttackSummary, T> g) {
        return obj -> g.apply((AttackSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attackId;
        private String resourceArn;
        private Instant startTime;
        private Instant endTime;
        private List<AttackVectorDescription> attackVectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttackSummary model) {
            this.attackId(model.attackId);
            this.resourceArn(model.resourceArn);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.attackVectors(model.attackVectors);
        }

        public final String getAttackId() {
            return this.attackId;
        }

        @Override
        public final Builder attackId(String attackId) {
            this.attackId = attackId;
            return this;
        }

        public final void setAttackId(String attackId) {
            this.attackId = attackId;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<AttackVectorDescription.Builder> getAttackVectors() {
            if (this.attackVectors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attackVectors != null ? (Collection)this.attackVectors.stream().map(AttackVectorDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attackVectors(Collection<AttackVectorDescription> attackVectors) {
            this.attackVectors = AttackVectorDescriptionListCopier.copy(attackVectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackVectors(AttackVectorDescription ... attackVectors) {
            this.attackVectors(Arrays.asList(attackVectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackVectors(Consumer<AttackVectorDescription.Builder> ... attackVectors) {
            this.attackVectors(Stream.of(attackVectors).map(c -> (AttackVectorDescription)((AttackVectorDescription.Builder)AttackVectorDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttackVectors(Collection<AttackVectorDescription.BuilderImpl> attackVectors) {
            this.attackVectors = AttackVectorDescriptionListCopier.copyFromBuilder(attackVectors);
        }

        public AttackSummary build() {
            return new AttackSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttackSummary> {
        public Builder attackId(String var1);

        public Builder resourceArn(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder attackVectors(Collection<AttackVectorDescription> var1);

        public Builder attackVectors(AttackVectorDescription ... var1);

        public Builder attackVectors(Consumer<AttackVectorDescription.Builder> ... var1);
    }
}

