/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.shield.ShieldAsyncClient;
import software.amazon.awssdk.services.shield.model.ListProtectionsRequest;
import software.amazon.awssdk.services.shield.model.ListProtectionsResponse;
import software.amazon.awssdk.services.shield.model.Protection;

public class ListProtectionsPublisher
implements SdkPublisher<ListProtectionsResponse> {
    private final ShieldAsyncClient client;
    private final ListProtectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProtectionsPublisher(ShieldAsyncClient client, ListProtectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProtectionsPublisher(ShieldAsyncClient client, ListProtectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProtectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProtectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Protection> protections() {
        Function<ListProtectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.protections() != null) {
                return response.protections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProtectionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProtectionsResponseFetcher
    implements AsyncPageFetcher<ListProtectionsResponse> {
        private ListProtectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListProtectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProtectionsResponse> nextPage(ListProtectionsResponse previousPage) {
            if (previousPage == null) {
                return ListProtectionsPublisher.this.client.listProtections(ListProtectionsPublisher.this.firstRequest);
            }
            return ListProtectionsPublisher.this.client.listProtections((ListProtectionsRequest)((Object)ListProtectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

