/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.shield.model.ShieldRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProtectionRequest
extends ShieldRequest
implements ToCopyableBuilder<Builder, DescribeProtectionRequest> {
    private static final SdkField<String> PROTECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectionId").getter(DescribeProtectionRequest.getter(DescribeProtectionRequest::protectionId)).setter(DescribeProtectionRequest.setter(Builder::protectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(DescribeProtectionRequest.getter(DescribeProtectionRequest::resourceArn)).setter(DescribeProtectionRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_ID_FIELD, RESOURCE_ARN_FIELD));
    private final String protectionId;
    private final String resourceArn;

    private DescribeProtectionRequest(BuilderImpl builder) {
        super(builder);
        this.protectionId = builder.protectionId;
        this.resourceArn = builder.resourceArn;
    }

    public String protectionId() {
        return this.protectionId;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.protectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProtectionRequest)) {
            return false;
        }
        DescribeProtectionRequest other = (DescribeProtectionRequest)((Object)obj);
        return Objects.equals(this.protectionId(), other.protectionId()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public String toString() {
        return ToString.builder((String)"DescribeProtectionRequest").add("ProtectionId", (Object)this.protectionId()).add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectionId": {
                return Optional.ofNullable(clazz.cast(this.protectionId()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProtectionRequest, T> g) {
        return obj -> g.apply((DescribeProtectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ShieldRequest.BuilderImpl
    implements Builder {
        private String protectionId;
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProtectionRequest model) {
            super(model);
            this.protectionId(model.protectionId);
            this.resourceArn(model.resourceArn);
        }

        public final String getProtectionId() {
            return this.protectionId;
        }

        @Override
        public final Builder protectionId(String protectionId) {
            this.protectionId = protectionId;
            return this;
        }

        public final void setProtectionId(String protectionId) {
            this.protectionId = protectionId;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeProtectionRequest build() {
            return new DescribeProtectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ShieldRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProtectionRequest> {
        public Builder protectionId(String var1);

        public Builder resourceArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

