/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.Protection;
import software.amazon.awssdk.services.shield.model.ProtectionsCopier;
import software.amazon.awssdk.services.shield.model.ShieldResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProtectionsResponse
extends ShieldResponse
implements ToCopyableBuilder<Builder, ListProtectionsResponse> {
    private static final SdkField<List<Protection>> PROTECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protections").getter(ListProtectionsResponse.getter(ListProtectionsResponse::protections)).setter(ListProtectionsResponse.setter(Builder::protections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Protection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProtectionsResponse.getter(ListProtectionsResponse::nextToken)).setter(ListProtectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Protection> protections;
    private final String nextToken;

    private ListProtectionsResponse(BuilderImpl builder) {
        super(builder);
        this.protections = builder.protections;
        this.nextToken = builder.nextToken;
    }

    public boolean hasProtections() {
        return this.protections != null && !(this.protections instanceof SdkAutoConstructList);
    }

    public List<Protection> protections() {
        return this.protections;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.protections());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProtectionsResponse)) {
            return false;
        }
        ListProtectionsResponse other = (ListProtectionsResponse)((Object)obj);
        return Objects.equals(this.protections(), other.protections()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListProtectionsResponse").add("Protections", this.protections()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protections": {
                return Optional.ofNullable(clazz.cast(this.protections()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProtectionsResponse, T> g) {
        return obj -> g.apply((ListProtectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ShieldResponse.BuilderImpl
    implements Builder {
        private List<Protection> protections = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProtectionsResponse model) {
            super(model);
            this.protections(model.protections);
            this.nextToken(model.nextToken);
        }

        public final Collection<Protection.Builder> getProtections() {
            return this.protections != null ? (Collection)this.protections.stream().map(Protection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder protections(Collection<Protection> protections) {
            this.protections = ProtectionsCopier.copy(protections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protections(Protection ... protections) {
            this.protections(Arrays.asList(protections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protections(Consumer<Protection.Builder> ... protections) {
            this.protections(Stream.of(protections).map(c -> (Protection)((Protection.Builder)Protection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProtections(Collection<Protection.BuilderImpl> protections) {
            this.protections = ProtectionsCopier.copyFromBuilder(protections);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListProtectionsResponse build() {
            return new ListProtectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ShieldResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProtectionsResponse> {
        public Builder protections(Collection<Protection> var1);

        public Builder protections(Protection ... var1);

        public Builder protections(Consumer<Protection.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

