/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.shield.ShieldClient;
import software.amazon.awssdk.services.shield.model.ListProtectionsRequest;
import software.amazon.awssdk.services.shield.model.ListProtectionsResponse;
import software.amazon.awssdk.services.shield.model.Protection;

public class ListProtectionsIterable
implements SdkIterable<ListProtectionsResponse> {
    private final ShieldClient client;
    private final ListProtectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProtectionsIterable(ShieldClient client, ListProtectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProtectionsResponseFetcher();
    }

    public Iterator<ListProtectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Protection> protections() {
        Function<ListProtectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.protections() != null) {
                return response.protections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProtectionsResponseFetcher
    implements SyncPageFetcher<ListProtectionsResponse> {
        private ListProtectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListProtectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProtectionsResponse nextPage(ListProtectionsResponse previousPage) {
            if (previousPage == null) {
                return ListProtectionsIterable.this.client.listProtections(ListProtectionsIterable.this.firstRequest);
            }
            return ListProtectionsIterable.this.client.listProtections((ListProtectionsRequest)((Object)ListProtectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

