/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the AWS Shield Advanced subscription for an account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Subscription implements SdkPojo, Serializable, ToCopyableBuilder<Subscription.Builder, Subscription> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Subscription::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Subscription::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Long> TIME_COMMITMENT_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Subscription::timeCommitmentInSeconds)).setter(setter(Builder::timeCommitmentInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeCommitmentInSeconds").build())
            .build();

    private static final SdkField<String> AUTO_RENEW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Subscription::autoRenewAsString)).setter(setter(Builder::autoRenew))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRenew").build()).build();

    private static final SdkField<List<Limit>> LIMITS_FIELD = SdkField
            .<List<Limit>> builder(MarshallingType.LIST)
            .getter(getter(Subscription::limits))
            .setter(setter(Builder::limits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Limit> builder(MarshallingType.SDK_POJO)
                                            .constructor(Limit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, TIME_COMMITMENT_IN_SECONDS_FIELD, AUTO_RENEW_FIELD, LIMITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant startTime;

    private final Instant endTime;

    private final Long timeCommitmentInSeconds;

    private final String autoRenew;

    private final List<Limit> limits;

    private Subscription(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.timeCommitmentInSeconds = builder.timeCommitmentInSeconds;
        this.autoRenew = builder.autoRenew;
        this.limits = builder.limits;
    }

    /**
     * <p>
     * The start time of the subscription, in Unix time in seconds. For more information see <a
     * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.
     * </p>
     * 
     * @return The start time of the subscription, in Unix time in seconds. For more information see <a
     *         href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types"
     *         >timestamp</a>.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time your subscription will end.
     * </p>
     * 
     * @return The date and time your subscription will end.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The length, in seconds, of the AWS Shield Advanced subscription for the account.
     * </p>
     * 
     * @return The length, in seconds, of the AWS Shield Advanced subscription for the account.
     */
    public Long timeCommitmentInSeconds() {
        return timeCommitmentInSeconds;
    }

    /**
     * <p>
     * If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing subscription
     * period.
     * </p>
     * <p>
     * When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can change
     * this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code> request
     * does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code> remains
     * unchanged.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoRenew} will
     * return {@link AutoRenew#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoRenewAsString}.
     * </p>
     * 
     * @return If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing
     *         subscription period.</p>
     *         <p>
     *         When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can
     *         change this by submitting an <code>UpdateSubscription</code> request. If the
     *         <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the
     *         existing value for <code>AutoRenew</code> remains unchanged.
     * @see AutoRenew
     */
    public AutoRenew autoRenew() {
        return AutoRenew.fromValue(autoRenew);
    }

    /**
     * <p>
     * If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing subscription
     * period.
     * </p>
     * <p>
     * When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can change
     * this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code> request
     * does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code> remains
     * unchanged.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoRenew} will
     * return {@link AutoRenew#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoRenewAsString}.
     * </p>
     * 
     * @return If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing
     *         subscription period.</p>
     *         <p>
     *         When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can
     *         change this by submitting an <code>UpdateSubscription</code> request. If the
     *         <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the
     *         existing value for <code>AutoRenew</code> remains unchanged.
     * @see AutoRenew
     */
    public String autoRenewAsString() {
        return autoRenew;
    }

    /**
     * Returns true if the Limits property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLimits() {
        return limits != null && !(limits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies how many protections of a given type you can create.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLimits()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies how many protections of a given type you can create.
     */
    public List<Limit> limits() {
        return limits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(timeCommitmentInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(autoRenewAsString());
        hashCode = 31 * hashCode + Objects.hashCode(limits());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(timeCommitmentInSeconds(), other.timeCommitmentInSeconds())
                && Objects.equals(autoRenewAsString(), other.autoRenewAsString()) && Objects.equals(limits(), other.limits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Subscription").add("StartTime", startTime()).add("EndTime", endTime())
                .add("TimeCommitmentInSeconds", timeCommitmentInSeconds()).add("AutoRenew", autoRenewAsString())
                .add("Limits", limits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "TimeCommitmentInSeconds":
            return Optional.ofNullable(clazz.cast(timeCommitmentInSeconds()));
        case "AutoRenew":
            return Optional.ofNullable(clazz.cast(autoRenewAsString()));
        case "Limits":
            return Optional.ofNullable(clazz.cast(limits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Subscription, T> g) {
        return obj -> g.apply((Subscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Subscription> {
        /**
         * <p>
         * The start time of the subscription, in Unix time in seconds. For more information see <a
         * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.
         * </p>
         * 
         * @param startTime
         *        The start time of the subscription, in Unix time in seconds. For more information see <a
         *        href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types"
         *        >timestamp</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time your subscription will end.
         * </p>
         * 
         * @param endTime
         *        The date and time your subscription will end.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The length, in seconds, of the AWS Shield Advanced subscription for the account.
         * </p>
         * 
         * @param timeCommitmentInSeconds
         *        The length, in seconds, of the AWS Shield Advanced subscription for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeCommitmentInSeconds(Long timeCommitmentInSeconds);

        /**
         * <p>
         * If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing
         * subscription period.
         * </p>
         * <p>
         * When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can
         * change this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code>
         * request does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code>
         * remains unchanged.
         * </p>
         * 
         * @param autoRenew
         *        If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing
         *        subscription period.</p>
         *        <p>
         *        When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You
         *        can change this by submitting an <code>UpdateSubscription</code> request. If the
         *        <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the
         *        existing value for <code>AutoRenew</code> remains unchanged.
         * @see AutoRenew
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRenew
         */
        Builder autoRenew(String autoRenew);

        /**
         * <p>
         * If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing
         * subscription period.
         * </p>
         * <p>
         * When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can
         * change this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code>
         * request does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code>
         * remains unchanged.
         * </p>
         * 
         * @param autoRenew
         *        If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing
         *        subscription period.</p>
         *        <p>
         *        When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You
         *        can change this by submitting an <code>UpdateSubscription</code> request. If the
         *        <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the
         *        existing value for <code>AutoRenew</code> remains unchanged.
         * @see AutoRenew
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRenew
         */
        Builder autoRenew(AutoRenew autoRenew);

        /**
         * <p>
         * Specifies how many protections of a given type you can create.
         * </p>
         * 
         * @param limits
         *        Specifies how many protections of a given type you can create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(Collection<Limit> limits);

        /**
         * <p>
         * Specifies how many protections of a given type you can create.
         * </p>
         * 
         * @param limits
         *        Specifies how many protections of a given type you can create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(Limit... limits);

        /**
         * <p>
         * Specifies how many protections of a given type you can create.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Limit>.Builder} avoiding the need to create
         * one manually via {@link List<Limit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Limit>.Builder#build()} is called immediately and its result
         * is passed to {@link #limits(List<Limit>)}.
         * 
         * @param limits
         *        a consumer that will call methods on {@link List<Limit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limits(List<Limit>)
         */
        Builder limits(Consumer<Limit.Builder>... limits);
    }

    static final class BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private Long timeCommitmentInSeconds;

        private String autoRenew;

        private List<Limit> limits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            startTime(model.startTime);
            endTime(model.endTime);
            timeCommitmentInSeconds(model.timeCommitmentInSeconds);
            autoRenew(model.autoRenew);
            limits(model.limits);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Long getTimeCommitmentInSeconds() {
            return timeCommitmentInSeconds;
        }

        @Override
        public final Builder timeCommitmentInSeconds(Long timeCommitmentInSeconds) {
            this.timeCommitmentInSeconds = timeCommitmentInSeconds;
            return this;
        }

        public final void setTimeCommitmentInSeconds(Long timeCommitmentInSeconds) {
            this.timeCommitmentInSeconds = timeCommitmentInSeconds;
        }

        public final String getAutoRenew() {
            return autoRenew;
        }

        @Override
        public final Builder autoRenew(String autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        @Override
        public final Builder autoRenew(AutoRenew autoRenew) {
            this.autoRenew(autoRenew == null ? null : autoRenew.toString());
            return this;
        }

        public final void setAutoRenew(String autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final Collection<Limit.Builder> getLimits() {
            return limits != null ? limits.stream().map(Limit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder limits(Collection<Limit> limits) {
            this.limits = LimitsCopier.copy(limits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limits(Limit... limits) {
            limits(Arrays.asList(limits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limits(Consumer<Limit.Builder>... limits) {
            limits(Stream.of(limits).map(c -> Limit.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLimits(Collection<Limit.BuilderImpl> limits) {
            this.limits = LimitsCopier.copyFromBuilder(limits);
        }

        @Override
        public Subscription build() {
            return new Subscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
