/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAttacksResponse extends ShieldResponse implements
        ToCopyableBuilder<ListAttacksResponse.Builder, ListAttacksResponse> {
    private static final SdkField<List<AttackSummary>> ATTACK_SUMMARIES_FIELD = SdkField
            .<List<AttackSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListAttacksResponse::attackSummaries))
            .setter(setter(Builder::attackSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttackSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttackSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAttacksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACK_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AttackSummary> attackSummaries;

    private final String nextToken;

    private ListAttacksResponse(BuilderImpl builder) {
        super(builder);
        this.attackSummaries = builder.attackSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AttackSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAttackSummaries() {
        return attackSummaries != null && !(attackSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attack information for the specified time range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttackSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attack information for the specified time range.
     */
    public List<AttackSummary> attackSummaries() {
        return attackSummaries;
    }

    /**
     * <p>
     * The token returned by a previous call to indicate that there is more data available. If not null, more results
     * are available. Pass this value for the <code>NextMarker</code> parameter in a subsequent call to
     * <code>ListAttacks</code> to retrieve the next set of items.
     * </p>
     * <p>
     * AWS WAF might return the list of <a>AttackSummary</a> objects in batches smaller than the number specified by
     * MaxResults. If there are more <a>AttackSummary</a> objects to return, AWS WAF will always also return a
     * <code>NextToken</code>.
     * </p>
     * 
     * @return The token returned by a previous call to indicate that there is more data available. If not null, more
     *         results are available. Pass this value for the <code>NextMarker</code> parameter in a subsequent call to
     *         <code>ListAttacks</code> to retrieve the next set of items.</p>
     *         <p>
     *         AWS WAF might return the list of <a>AttackSummary</a> objects in batches smaller than the number
     *         specified by MaxResults. If there are more <a>AttackSummary</a> objects to return, AWS WAF will always
     *         also return a <code>NextToken</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attackSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttacksResponse)) {
            return false;
        }
        ListAttacksResponse other = (ListAttacksResponse) obj;
        return Objects.equals(attackSummaries(), other.attackSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAttacksResponse").add("AttackSummaries", attackSummaries()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttackSummaries":
            return Optional.ofNullable(clazz.cast(attackSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAttacksResponse, T> g) {
        return obj -> g.apply((ListAttacksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ShieldResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAttacksResponse> {
        /**
         * <p>
         * The attack information for the specified time range.
         * </p>
         * 
         * @param attackSummaries
         *        The attack information for the specified time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackSummaries(Collection<AttackSummary> attackSummaries);

        /**
         * <p>
         * The attack information for the specified time range.
         * </p>
         * 
         * @param attackSummaries
         *        The attack information for the specified time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackSummaries(AttackSummary... attackSummaries);

        /**
         * <p>
         * The attack information for the specified time range.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttackSummary>.Builder} avoiding the need
         * to create one manually via {@link List<AttackSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttackSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #attackSummaries(List<AttackSummary>)}.
         * 
         * @param attackSummaries
         *        a consumer that will call methods on {@link List<AttackSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attackSummaries(List<AttackSummary>)
         */
        Builder attackSummaries(Consumer<AttackSummary.Builder>... attackSummaries);

        /**
         * <p>
         * The token returned by a previous call to indicate that there is more data available. If not null, more
         * results are available. Pass this value for the <code>NextMarker</code> parameter in a subsequent call to
         * <code>ListAttacks</code> to retrieve the next set of items.
         * </p>
         * <p>
         * AWS WAF might return the list of <a>AttackSummary</a> objects in batches smaller than the number specified by
         * MaxResults. If there are more <a>AttackSummary</a> objects to return, AWS WAF will always also return a
         * <code>NextToken</code>.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to indicate that there is more data available. If not null, more
         *        results are available. Pass this value for the <code>NextMarker</code> parameter in a subsequent call
         *        to <code>ListAttacks</code> to retrieve the next set of items.</p>
         *        <p>
         *        AWS WAF might return the list of <a>AttackSummary</a> objects in batches smaller than the number
         *        specified by MaxResults. If there are more <a>AttackSummary</a> objects to return, AWS WAF will always
         *        also return a <code>NextToken</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ShieldResponse.BuilderImpl implements Builder {
        private List<AttackSummary> attackSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttacksResponse model) {
            super(model);
            attackSummaries(model.attackSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<AttackSummary.Builder> getAttackSummaries() {
            return attackSummaries != null ? attackSummaries.stream().map(AttackSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder attackSummaries(Collection<AttackSummary> attackSummaries) {
            this.attackSummaries = AttackSummariesCopier.copy(attackSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackSummaries(AttackSummary... attackSummaries) {
            attackSummaries(Arrays.asList(attackSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackSummaries(Consumer<AttackSummary.Builder>... attackSummaries) {
            attackSummaries(Stream.of(attackSummaries).map(c -> AttackSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttackSummaries(Collection<AttackSummary.BuilderImpl> attackSummaries) {
            this.attackSummaries = AttackSummariesCopier.copyFromBuilder(attackSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAttacksResponse build() {
            return new ListAttacksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
