/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSubscriptionResponse extends ShieldResponse implements
        ToCopyableBuilder<DescribeSubscriptionResponse.Builder, DescribeSubscriptionResponse> {
    private static final SdkField<Subscription> SUBSCRIPTION_FIELD = SdkField.<Subscription> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeSubscriptionResponse::subscription)).setter(setter(Builder::subscription))
            .constructor(Subscription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_FIELD));

    private final Subscription subscription;

    private DescribeSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.subscription = builder.subscription;
    }

    /**
     * <p>
     * The AWS Shield Advanced subscription details for an account.
     * </p>
     * 
     * @return The AWS Shield Advanced subscription details for an account.
     */
    public Subscription subscription() {
        return subscription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubscriptionResponse)) {
            return false;
        }
        DescribeSubscriptionResponse other = (DescribeSubscriptionResponse) obj;
        return Objects.equals(subscription(), other.subscription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSubscriptionResponse").add("Subscription", subscription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subscription":
            return Optional.ofNullable(clazz.cast(subscription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSubscriptionResponse, T> g) {
        return obj -> g.apply((DescribeSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ShieldResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSubscriptionResponse> {
        /**
         * <p>
         * The AWS Shield Advanced subscription details for an account.
         * </p>
         * 
         * @param subscription
         *        The AWS Shield Advanced subscription details for an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscription(Subscription subscription);

        /**
         * <p>
         * The AWS Shield Advanced subscription details for an account.
         * </p>
         * This is a convenience that creates an instance of the {@link Subscription.Builder} avoiding the need to
         * create one manually via {@link Subscription#builder()}.
         *
         * When the {@link Consumer} completes, {@link Subscription.Builder#build()} is called immediately and its
         * result is passed to {@link #subscription(Subscription)}.
         * 
         * @param subscription
         *        a consumer that will call methods on {@link Subscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscription(Subscription)
         */
        default Builder subscription(Consumer<Subscription.Builder> subscription) {
            return subscription(Subscription.builder().applyMutation(subscription).build());
        }
    }

    static final class BuilderImpl extends ShieldResponse.BuilderImpl implements Builder {
        private Subscription subscription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubscriptionResponse model) {
            super(model);
            subscription(model.subscription);
        }

        public final Subscription.Builder getSubscription() {
            return subscription != null ? subscription.toBuilder() : null;
        }

        @Override
        public final Builder subscription(Subscription subscription) {
            this.subscription = subscription;
            return this;
        }

        public final void setSubscription(Subscription.BuilderImpl subscription) {
            this.subscription = subscription != null ? subscription.build() : null;
        }

        @Override
        public DescribeSubscriptionResponse build() {
            return new DescribeSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
