/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeRange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeRange> {
    private static final SdkField<Instant> FROM_INCLUSIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TimeRange.getter(TimeRange::fromInclusive)).setter(TimeRange.setter(Builder::fromInclusive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromInclusive").build()}).build();
    private static final SdkField<Instant> TO_EXCLUSIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TimeRange.getter(TimeRange::toExclusive)).setter(TimeRange.setter(Builder::toExclusive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToExclusive").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_INCLUSIVE_FIELD, TO_EXCLUSIVE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant fromInclusive;
    private final Instant toExclusive;

    private TimeRange(BuilderImpl builder) {
        this.fromInclusive = builder.fromInclusive;
        this.toExclusive = builder.toExclusive;
    }

    public Instant fromInclusive() {
        return this.fromInclusive;
    }

    public Instant toExclusive() {
        return this.toExclusive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fromInclusive());
        hashCode = 31 * hashCode + Objects.hashCode(this.toExclusive());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeRange)) {
            return false;
        }
        TimeRange other = (TimeRange)obj;
        return Objects.equals(this.fromInclusive(), other.fromInclusive()) && Objects.equals(this.toExclusive(), other.toExclusive());
    }

    public String toString() {
        return ToString.builder((String)"TimeRange").add("FromInclusive", (Object)this.fromInclusive()).add("ToExclusive", (Object)this.toExclusive()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FromInclusive": {
                return Optional.ofNullable(clazz.cast(this.fromInclusive()));
            }
            case "ToExclusive": {
                return Optional.ofNullable(clazz.cast(this.toExclusive()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeRange, T> g) {
        return obj -> g.apply((TimeRange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant fromInclusive;
        private Instant toExclusive;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeRange model) {
            this.fromInclusive(model.fromInclusive);
            this.toExclusive(model.toExclusive);
        }

        public final Instant getFromInclusive() {
            return this.fromInclusive;
        }

        @Override
        public final Builder fromInclusive(Instant fromInclusive) {
            this.fromInclusive = fromInclusive;
            return this;
        }

        public final void setFromInclusive(Instant fromInclusive) {
            this.fromInclusive = fromInclusive;
        }

        public final Instant getToExclusive() {
            return this.toExclusive;
        }

        @Override
        public final Builder toExclusive(Instant toExclusive) {
            this.toExclusive = toExclusive;
            return this;
        }

        public final void setToExclusive(Instant toExclusive) {
            this.toExclusive = toExclusive;
        }

        public TimeRange build() {
            return new TimeRange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeRange> {
        public Builder fromInclusive(Instant var1);

        public Builder toExclusive(Instant var1);
    }
}

