/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The mitigation applied to a DDoS attack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Mitigation implements SdkPojo, Serializable, ToCopyableBuilder<Mitigation.Builder, Mitigation> {
    private static final SdkField<String> MITIGATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mitigation::mitigationName)).setter(setter(Builder::mitigationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MitigationName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MITIGATION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mitigationName;

    private Mitigation(BuilderImpl builder) {
        this.mitigationName = builder.mitigationName;
    }

    /**
     * <p>
     * The name of the mitigation taken for this attack.
     * </p>
     * 
     * @return The name of the mitigation taken for this attack.
     */
    public String mitigationName() {
        return mitigationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mitigationName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mitigation)) {
            return false;
        }
        Mitigation other = (Mitigation) obj;
        return Objects.equals(mitigationName(), other.mitigationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Mitigation").add("MitigationName", mitigationName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MitigationName":
            return Optional.ofNullable(clazz.cast(mitigationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Mitigation, T> g) {
        return obj -> g.apply((Mitigation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Mitigation> {
        /**
         * <p>
         * The name of the mitigation taken for this attack.
         * </p>
         * 
         * @param mitigationName
         *        The name of the mitigation taken for this attack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mitigationName(String mitigationName);
    }

    static final class BuilderImpl implements Builder {
        private String mitigationName;

        private BuilderImpl() {
        }

        private BuilderImpl(Mitigation model) {
            mitigationName(model.mitigationName);
        }

        public final String getMitigationName() {
            return mitigationName;
        }

        @Override
        public final Builder mitigationName(String mitigationName) {
            this.mitigationName = mitigationName;
            return this;
        }

        public final void setMitigationName(String mitigationName) {
            this.mitigationName = mitigationName;
        }

        @Override
        public Mitigation build() {
            return new Mitigation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
