/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProtectionRequest extends ShieldRequest implements
        ToCopyableBuilder<DescribeProtectionRequest.Builder, DescribeProtectionRequest> {
    private static final SdkField<String> PROTECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProtectionRequest::protectionId)).setter(setter(Builder::protectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionId").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProtectionRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_ID_FIELD,
            RESOURCE_ARN_FIELD));

    private final String protectionId;

    private final String resourceArn;

    private DescribeProtectionRequest(BuilderImpl builder) {
        super(builder);
        this.protectionId = builder.protectionId;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The unique identifier (ID) for the <a>Protection</a> object that is described. When submitting the
     * <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the
     * <code>ProtectionID</code>, but not both.
     * </p>
     * 
     * @return The unique identifier (ID) for the <a>Protection</a> object that is described. When submitting the
     *         <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the
     *         <code>ProtectionID</code>, but not both.
     */
    public String protectionId() {
        return protectionId;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the AWS resource for the <a>Protection</a> object that is described. When
     * submitting the <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or
     * the <code>ProtectionID</code>, but not both.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the AWS resource for the <a>Protection</a> object that is described.
     *         When submitting the <code>DescribeProtection</code> request you must provide either the
     *         <code>ResourceArn</code> or the <code>ProtectionID</code>, but not both.
     */
    public String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protectionId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProtectionRequest)) {
            return false;
        }
        DescribeProtectionRequest other = (DescribeProtectionRequest) obj;
        return Objects.equals(protectionId(), other.protectionId()) && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeProtectionRequest").add("ProtectionId", protectionId())
                .add("ResourceArn", resourceArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectionId":
            return Optional.ofNullable(clazz.cast(protectionId()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProtectionRequest, T> g) {
        return obj -> g.apply((DescribeProtectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ShieldRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProtectionRequest> {
        /**
         * <p>
         * The unique identifier (ID) for the <a>Protection</a> object that is described. When submitting the
         * <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the
         * <code>ProtectionID</code>, but not both.
         * </p>
         * 
         * @param protectionId
         *        The unique identifier (ID) for the <a>Protection</a> object that is described. When submitting the
         *        <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the
         *        <code>ProtectionID</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectionId(String protectionId);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the AWS resource for the <a>Protection</a> object that is described. When
         * submitting the <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code>
         * or the <code>ProtectionID</code>, but not both.
         * </p>
         * 
         * @param resourceArn
         *        The ARN (Amazon Resource Name) of the AWS resource for the <a>Protection</a> object that is described.
         *        When submitting the <code>DescribeProtection</code> request you must provide either the
         *        <code>ResourceArn</code> or the <code>ProtectionID</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ShieldRequest.BuilderImpl implements Builder {
        private String protectionId;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProtectionRequest model) {
            super(model);
            protectionId(model.protectionId);
            resourceArn(model.resourceArn);
        }

        public final String getProtectionId() {
            return protectionId;
        }

        @Override
        public final Builder protectionId(String protectionId) {
            this.protectionId = protectionId;
            return this;
        }

        public final void setProtectionId(String protectionId) {
            this.protectionId = protectionId;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeProtectionRequest build() {
            return new DescribeProtectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
