/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAttackResponse extends ShieldResponse implements
        ToCopyableBuilder<DescribeAttackResponse.Builder, DescribeAttackResponse> {
    private static final SdkField<AttackDetail> ATTACK_FIELD = SdkField.<AttackDetail> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeAttackResponse::attack)).setter(setter(Builder::attack)).constructor(AttackDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attack").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACK_FIELD));

    private final AttackDetail attack;

    private DescribeAttackResponse(BuilderImpl builder) {
        super(builder);
        this.attack = builder.attack;
    }

    /**
     * <p>
     * The attack that is described.
     * </p>
     * 
     * @return The attack that is described.
     */
    public AttackDetail attack() {
        return attack;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attack());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAttackResponse)) {
            return false;
        }
        DescribeAttackResponse other = (DescribeAttackResponse) obj;
        return Objects.equals(attack(), other.attack());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAttackResponse").add("Attack", attack()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attack":
            return Optional.ofNullable(clazz.cast(attack()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAttackResponse, T> g) {
        return obj -> g.apply((DescribeAttackResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ShieldResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAttackResponse> {
        /**
         * <p>
         * The attack that is described.
         * </p>
         * 
         * @param attack
         *        The attack that is described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attack(AttackDetail attack);

        /**
         * <p>
         * The attack that is described.
         * </p>
         * This is a convenience that creates an instance of the {@link AttackDetail.Builder} avoiding the need to
         * create one manually via {@link AttackDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttackDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #attack(AttackDetail)}.
         * 
         * @param attack
         *        a consumer that will call methods on {@link AttackDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attack(AttackDetail)
         */
        default Builder attack(Consumer<AttackDetail.Builder> attack) {
            return attack(AttackDetail.builder().applyMutation(attack).build());
        }
    }

    static final class BuilderImpl extends ShieldResponse.BuilderImpl implements Builder {
        private AttackDetail attack;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAttackResponse model) {
            super(model);
            attack(model.attack);
        }

        public final AttackDetail.Builder getAttack() {
            return attack != null ? attack.toBuilder() : null;
        }

        @Override
        public final Builder attack(AttackDetail attack) {
            this.attack = attack;
            return this;
        }

        public final void setAttack(AttackDetail.BuilderImpl attack) {
            this.attack = attack != null ? attack.build() : null;
        }

        @Override
        public DescribeAttackResponse build() {
            return new DescribeAttackResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
