/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the described attack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttackProperty implements SdkPojo, Serializable, ToCopyableBuilder<AttackProperty.Builder, AttackProperty> {
    private static final SdkField<String> ATTACK_LAYER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttackProperty::attackLayerAsString)).setter(setter(Builder::attackLayer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackLayer").build()).build();

    private static final SdkField<String> ATTACK_PROPERTY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttackProperty::attackPropertyIdentifierAsString)).setter(setter(Builder::attackPropertyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackPropertyIdentifier").build())
            .build();

    private static final SdkField<List<Contributor>> TOP_CONTRIBUTORS_FIELD = SdkField
            .<List<Contributor>> builder(MarshallingType.LIST)
            .getter(getter(AttackProperty::topContributors))
            .setter(setter(Builder::topContributors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopContributors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Contributor> builder(MarshallingType.SDK_POJO)
                                            .constructor(Contributor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttackProperty::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<Long> TOTAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(AttackProperty::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACK_LAYER_FIELD,
            ATTACK_PROPERTY_IDENTIFIER_FIELD, TOP_CONTRIBUTORS_FIELD, UNIT_FIELD, TOTAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attackLayer;

    private final String attackPropertyIdentifier;

    private final List<Contributor> topContributors;

    private final String unit;

    private final Long total;

    private AttackProperty(BuilderImpl builder) {
        this.attackLayer = builder.attackLayer;
        this.attackPropertyIdentifier = builder.attackPropertyIdentifier;
        this.topContributors = builder.topContributors;
        this.unit = builder.unit;
        this.total = builder.total;
    }

    /**
     * <p>
     * The type of distributed denial of service (DDoS) event that was observed. <code>NETWORK</code> indicates layer 3
     * and layer 4 events and <code>APPLICATION</code> indicates layer 7 events.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attackLayer} will
     * return {@link AttackLayer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attackLayerAsString}.
     * </p>
     * 
     * @return The type of distributed denial of service (DDoS) event that was observed. <code>NETWORK</code> indicates
     *         layer 3 and layer 4 events and <code>APPLICATION</code> indicates layer 7 events.
     * @see AttackLayer
     */
    public AttackLayer attackLayer() {
        return AttackLayer.fromValue(attackLayer);
    }

    /**
     * <p>
     * The type of distributed denial of service (DDoS) event that was observed. <code>NETWORK</code> indicates layer 3
     * and layer 4 events and <code>APPLICATION</code> indicates layer 7 events.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attackLayer} will
     * return {@link AttackLayer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attackLayerAsString}.
     * </p>
     * 
     * @return The type of distributed denial of service (DDoS) event that was observed. <code>NETWORK</code> indicates
     *         layer 3 and layer 4 events and <code>APPLICATION</code> indicates layer 7 events.
     * @see AttackLayer
     */
    public String attackLayerAsString() {
        return attackLayer;
    }

    /**
     * <p>
     * Defines the DDoS attack property information that is provided. The <code>WORDPRESS_PINGBACK_REFLECTOR</code> and
     * <code>WORDPRESS_PINGBACK_SOURCE</code> values are valid only for WordPress reflective pingback DDoS attacks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attackPropertyIdentifier} will return {@link AttackPropertyIdentifier#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #attackPropertyIdentifierAsString}.
     * </p>
     * 
     * @return Defines the DDoS attack property information that is provided. The
     *         <code>WORDPRESS_PINGBACK_REFLECTOR</code> and <code>WORDPRESS_PINGBACK_SOURCE</code> values are valid
     *         only for WordPress reflective pingback DDoS attacks.
     * @see AttackPropertyIdentifier
     */
    public AttackPropertyIdentifier attackPropertyIdentifier() {
        return AttackPropertyIdentifier.fromValue(attackPropertyIdentifier);
    }

    /**
     * <p>
     * Defines the DDoS attack property information that is provided. The <code>WORDPRESS_PINGBACK_REFLECTOR</code> and
     * <code>WORDPRESS_PINGBACK_SOURCE</code> values are valid only for WordPress reflective pingback DDoS attacks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attackPropertyIdentifier} will return {@link AttackPropertyIdentifier#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #attackPropertyIdentifierAsString}.
     * </p>
     * 
     * @return Defines the DDoS attack property information that is provided. The
     *         <code>WORDPRESS_PINGBACK_REFLECTOR</code> and <code>WORDPRESS_PINGBACK_SOURCE</code> values are valid
     *         only for WordPress reflective pingback DDoS attacks.
     * @see AttackPropertyIdentifier
     */
    public String attackPropertyIdentifierAsString() {
        return attackPropertyIdentifier;
    }

    /**
     * Returns true if the TopContributors property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTopContributors() {
        return topContributors != null && !(topContributors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of <a>Contributor</a> objects that includes the top five contributors to an attack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTopContributors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The array of <a>Contributor</a> objects that includes the top five contributors to an attack.
     */
    public List<Contributor> topContributors() {
        return topContributors;
    }

    /**
     * <p>
     * The unit of the <code>Value</code> of the contributions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link Unit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of the <code>Value</code> of the contributions.
     * @see Unit
     */
    public Unit unit() {
        return Unit.fromValue(unit);
    }

    /**
     * <p>
     * The unit of the <code>Value</code> of the contributions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link Unit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of the <code>Value</code> of the contributions.
     * @see Unit
     */
    public String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * The total contributions made to this attack by all contributors, not just the five listed in the
     * <code>TopContributors</code> list.
     * </p>
     * 
     * @return The total contributions made to this attack by all contributors, not just the five listed in the
     *         <code>TopContributors</code> list.
     */
    public Long total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attackLayerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attackPropertyIdentifierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(topContributors());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackProperty)) {
            return false;
        }
        AttackProperty other = (AttackProperty) obj;
        return Objects.equals(attackLayerAsString(), other.attackLayerAsString())
                && Objects.equals(attackPropertyIdentifierAsString(), other.attackPropertyIdentifierAsString())
                && Objects.equals(topContributors(), other.topContributors())
                && Objects.equals(unitAsString(), other.unitAsString()) && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AttackProperty").add("AttackLayer", attackLayerAsString())
                .add("AttackPropertyIdentifier", attackPropertyIdentifierAsString()).add("TopContributors", topContributors())
                .add("Unit", unitAsString()).add("Total", total()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttackLayer":
            return Optional.ofNullable(clazz.cast(attackLayerAsString()));
        case "AttackPropertyIdentifier":
            return Optional.ofNullable(clazz.cast(attackPropertyIdentifierAsString()));
        case "TopContributors":
            return Optional.ofNullable(clazz.cast(topContributors()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttackProperty, T> g) {
        return obj -> g.apply((AttackProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttackProperty> {
        /**
         * <p>
         * The type of distributed denial of service (DDoS) event that was observed. <code>NETWORK</code> indicates
         * layer 3 and layer 4 events and <code>APPLICATION</code> indicates layer 7 events.
         * </p>
         * 
         * @param attackLayer
         *        The type of distributed denial of service (DDoS) event that was observed. <code>NETWORK</code>
         *        indicates layer 3 and layer 4 events and <code>APPLICATION</code> indicates layer 7 events.
         * @see AttackLayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttackLayer
         */
        Builder attackLayer(String attackLayer);

        /**
         * <p>
         * The type of distributed denial of service (DDoS) event that was observed. <code>NETWORK</code> indicates
         * layer 3 and layer 4 events and <code>APPLICATION</code> indicates layer 7 events.
         * </p>
         * 
         * @param attackLayer
         *        The type of distributed denial of service (DDoS) event that was observed. <code>NETWORK</code>
         *        indicates layer 3 and layer 4 events and <code>APPLICATION</code> indicates layer 7 events.
         * @see AttackLayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttackLayer
         */
        Builder attackLayer(AttackLayer attackLayer);

        /**
         * <p>
         * Defines the DDoS attack property information that is provided. The <code>WORDPRESS_PINGBACK_REFLECTOR</code>
         * and <code>WORDPRESS_PINGBACK_SOURCE</code> values are valid only for WordPress reflective pingback DDoS
         * attacks.
         * </p>
         * 
         * @param attackPropertyIdentifier
         *        Defines the DDoS attack property information that is provided. The
         *        <code>WORDPRESS_PINGBACK_REFLECTOR</code> and <code>WORDPRESS_PINGBACK_SOURCE</code> values are valid
         *        only for WordPress reflective pingback DDoS attacks.
         * @see AttackPropertyIdentifier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttackPropertyIdentifier
         */
        Builder attackPropertyIdentifier(String attackPropertyIdentifier);

        /**
         * <p>
         * Defines the DDoS attack property information that is provided. The <code>WORDPRESS_PINGBACK_REFLECTOR</code>
         * and <code>WORDPRESS_PINGBACK_SOURCE</code> values are valid only for WordPress reflective pingback DDoS
         * attacks.
         * </p>
         * 
         * @param attackPropertyIdentifier
         *        Defines the DDoS attack property information that is provided. The
         *        <code>WORDPRESS_PINGBACK_REFLECTOR</code> and <code>WORDPRESS_PINGBACK_SOURCE</code> values are valid
         *        only for WordPress reflective pingback DDoS attacks.
         * @see AttackPropertyIdentifier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttackPropertyIdentifier
         */
        Builder attackPropertyIdentifier(AttackPropertyIdentifier attackPropertyIdentifier);

        /**
         * <p>
         * The array of <a>Contributor</a> objects that includes the top five contributors to an attack.
         * </p>
         * 
         * @param topContributors
         *        The array of <a>Contributor</a> objects that includes the top five contributors to an attack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topContributors(Collection<Contributor> topContributors);

        /**
         * <p>
         * The array of <a>Contributor</a> objects that includes the top five contributors to an attack.
         * </p>
         * 
         * @param topContributors
         *        The array of <a>Contributor</a> objects that includes the top five contributors to an attack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topContributors(Contributor... topContributors);

        /**
         * <p>
         * The array of <a>Contributor</a> objects that includes the top five contributors to an attack.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Contributor>.Builder} avoiding the need to
         * create one manually via {@link List<Contributor>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Contributor>.Builder#build()} is called immediately and its
         * result is passed to {@link #topContributors(List<Contributor>)}.
         * 
         * @param topContributors
         *        a consumer that will call methods on {@link List<Contributor>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topContributors(List<Contributor>)
         */
        Builder topContributors(Consumer<Contributor.Builder>... topContributors);

        /**
         * <p>
         * The unit of the <code>Value</code> of the contributions.
         * </p>
         * 
         * @param unit
         *        The unit of the <code>Value</code> of the contributions.
         * @see Unit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Unit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit of the <code>Value</code> of the contributions.
         * </p>
         * 
         * @param unit
         *        The unit of the <code>Value</code> of the contributions.
         * @see Unit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Unit
         */
        Builder unit(Unit unit);

        /**
         * <p>
         * The total contributions made to this attack by all contributors, not just the five listed in the
         * <code>TopContributors</code> list.
         * </p>
         * 
         * @param total
         *        The total contributions made to this attack by all contributors, not just the five listed in the
         *        <code>TopContributors</code> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Long total);
    }

    static final class BuilderImpl implements Builder {
        private String attackLayer;

        private String attackPropertyIdentifier;

        private List<Contributor> topContributors = DefaultSdkAutoConstructList.getInstance();

        private String unit;

        private Long total;

        private BuilderImpl() {
        }

        private BuilderImpl(AttackProperty model) {
            attackLayer(model.attackLayer);
            attackPropertyIdentifier(model.attackPropertyIdentifier);
            topContributors(model.topContributors);
            unit(model.unit);
            total(model.total);
        }

        public final String getAttackLayerAsString() {
            return attackLayer;
        }

        @Override
        public final Builder attackLayer(String attackLayer) {
            this.attackLayer = attackLayer;
            return this;
        }

        @Override
        public final Builder attackLayer(AttackLayer attackLayer) {
            this.attackLayer(attackLayer == null ? null : attackLayer.toString());
            return this;
        }

        public final void setAttackLayer(String attackLayer) {
            this.attackLayer = attackLayer;
        }

        public final String getAttackPropertyIdentifierAsString() {
            return attackPropertyIdentifier;
        }

        @Override
        public final Builder attackPropertyIdentifier(String attackPropertyIdentifier) {
            this.attackPropertyIdentifier = attackPropertyIdentifier;
            return this;
        }

        @Override
        public final Builder attackPropertyIdentifier(AttackPropertyIdentifier attackPropertyIdentifier) {
            this.attackPropertyIdentifier(attackPropertyIdentifier == null ? null : attackPropertyIdentifier.toString());
            return this;
        }

        public final void setAttackPropertyIdentifier(String attackPropertyIdentifier) {
            this.attackPropertyIdentifier = attackPropertyIdentifier;
        }

        public final Collection<Contributor.Builder> getTopContributors() {
            return topContributors != null ? topContributors.stream().map(Contributor::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder topContributors(Collection<Contributor> topContributors) {
            this.topContributors = TopContributorsCopier.copy(topContributors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topContributors(Contributor... topContributors) {
            topContributors(Arrays.asList(topContributors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topContributors(Consumer<Contributor.Builder>... topContributors) {
            topContributors(Stream.of(topContributors).map(c -> Contributor.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTopContributors(Collection<Contributor.BuilderImpl> topContributors) {
            this.topContributors = TopContributorsCopier.copyFromBuilder(topContributors);
        }

        public final String getUnitAsString() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(Unit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Long getTotal() {
            return total;
        }

        @Override
        public final Builder total(Long total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Long total) {
            this.total = total;
        }

        @Override
        public AttackProperty build() {
            return new AttackProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
