/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.AutoRenew;
import software.amazon.awssdk.services.shield.model.Limit;
import software.amazon.awssdk.services.shield.model.LimitsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subscription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Subscription> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Subscription.getter(Subscription::startTime)).setter(Subscription.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Subscription.getter(Subscription::endTime)).setter(Subscription.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Long> TIME_COMMITMENT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(Subscription.getter(Subscription::timeCommitmentInSeconds)).setter(Subscription.setter(Builder::timeCommitmentInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeCommitmentInSeconds").build()}).build();
    private static final SdkField<String> AUTO_RENEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Subscription.getter(Subscription::autoRenewAsString)).setter(Subscription.setter(Builder::autoRenew)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRenew").build()}).build();
    private static final SdkField<List<Limit>> LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Subscription.getter(Subscription::limits)).setter(Subscription.setter(Builder::limits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Limit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, TIME_COMMITMENT_IN_SECONDS_FIELD, AUTO_RENEW_FIELD, LIMITS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant startTime;
    private final Instant endTime;
    private final Long timeCommitmentInSeconds;
    private final String autoRenew;
    private final List<Limit> limits;

    private Subscription(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.timeCommitmentInSeconds = builder.timeCommitmentInSeconds;
        this.autoRenew = builder.autoRenew;
        this.limits = builder.limits;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Long timeCommitmentInSeconds() {
        return this.timeCommitmentInSeconds;
    }

    public AutoRenew autoRenew() {
        return AutoRenew.fromValue(this.autoRenew);
    }

    public String autoRenewAsString() {
        return this.autoRenew;
    }

    public boolean hasLimits() {
        return this.limits != null && !(this.limits instanceof SdkAutoConstructList);
    }

    public List<Limit> limits() {
        return this.limits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeCommitmentInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRenewAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.limits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.timeCommitmentInSeconds(), other.timeCommitmentInSeconds()) && Objects.equals(this.autoRenewAsString(), other.autoRenewAsString()) && Objects.equals(this.limits(), other.limits());
    }

    public String toString() {
        return ToString.builder((String)"Subscription").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("TimeCommitmentInSeconds", (Object)this.timeCommitmentInSeconds()).add("AutoRenew", (Object)this.autoRenewAsString()).add("Limits", this.limits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "TimeCommitmentInSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeCommitmentInSeconds()));
            }
            case "AutoRenew": {
                return Optional.ofNullable(clazz.cast(this.autoRenewAsString()));
            }
            case "Limits": {
                return Optional.ofNullable(clazz.cast(this.limits()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Subscription, T> g) {
        return obj -> g.apply((Subscription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private Long timeCommitmentInSeconds;
        private String autoRenew;
        private List<Limit> limits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.timeCommitmentInSeconds(model.timeCommitmentInSeconds);
            this.autoRenew(model.autoRenew);
            this.limits(model.limits);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Long getTimeCommitmentInSeconds() {
            return this.timeCommitmentInSeconds;
        }

        @Override
        public final Builder timeCommitmentInSeconds(Long timeCommitmentInSeconds) {
            this.timeCommitmentInSeconds = timeCommitmentInSeconds;
            return this;
        }

        public final void setTimeCommitmentInSeconds(Long timeCommitmentInSeconds) {
            this.timeCommitmentInSeconds = timeCommitmentInSeconds;
        }

        public final String getAutoRenewAsString() {
            return this.autoRenew;
        }

        @Override
        public final Builder autoRenew(String autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        @Override
        public final Builder autoRenew(AutoRenew autoRenew) {
            this.autoRenew(autoRenew == null ? null : autoRenew.toString());
            return this;
        }

        public final void setAutoRenew(String autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final Collection<Limit.Builder> getLimits() {
            return this.limits != null ? (Collection)this.limits.stream().map(Limit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder limits(Collection<Limit> limits) {
            this.limits = LimitsCopier.copy(limits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limits(Limit ... limits) {
            this.limits(Arrays.asList(limits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limits(Consumer<Limit.Builder> ... limits) {
            this.limits(Stream.of(limits).map(c -> (Limit)((Limit.Builder)Limit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLimits(Collection<Limit.BuilderImpl> limits) {
            this.limits = LimitsCopier.copyFromBuilder(limits);
        }

        public Subscription build() {
            return new Subscription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Subscription> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder timeCommitmentInSeconds(Long var1);

        public Builder autoRenew(String var1);

        public Builder autoRenew(AutoRenew var1);

        public Builder limits(Collection<Limit> var1);

        public Builder limits(Limit ... var1);

        public Builder limits(Consumer<Limit.Builder> ... var1);
    }
}

