/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.shield.model.ResourceArnFilterListCopier;
import software.amazon.awssdk.services.shield.model.ShieldRequest;
import software.amazon.awssdk.services.shield.model.TimeRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAttacksRequest
extends ShieldRequest
implements ToCopyableBuilder<Builder, ListAttacksRequest> {
    private final List<String> resourceArns;
    private final TimeRange startTime;
    private final TimeRange endTime;
    private final String nextToken;
    private final Integer maxResults;

    private ListAttacksRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArns = builder.resourceArns;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<String> resourceArns() {
        return this.resourceArns;
    }

    public TimeRange startTime() {
        return this.startTime;
    }

    public TimeRange endTime() {
        return this.endTime;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttacksRequest)) {
            return false;
        }
        ListAttacksRequest other = (ListAttacksRequest)((Object)obj);
        return Objects.equals(this.resourceArns(), other.resourceArns()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListAttacksRequest").add("ResourceArns", this.resourceArns()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArns": {
                return Optional.of(clazz.cast(this.resourceArns()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ShieldRequest.BuilderImpl
    implements Builder {
        private List<String> resourceArns;
        private TimeRange startTime;
        private TimeRange endTime;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttacksRequest model) {
            this.resourceArns(model.resourceArns);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnFilterListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnFilterListCopier.copy(resourceArns);
        }

        public final TimeRange.Builder getStartTime() {
            return this.startTime != null ? this.startTime.toBuilder() : null;
        }

        @Override
        public final Builder startTime(TimeRange startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(TimeRange.BuilderImpl startTime) {
            this.startTime = startTime != null ? startTime.build() : null;
        }

        public final TimeRange.Builder getEndTime() {
            return this.endTime != null ? this.endTime.toBuilder() : null;
        }

        @Override
        public final Builder endTime(TimeRange endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(TimeRange.BuilderImpl endTime) {
            this.endTime = endTime != null ? endTime.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListAttacksRequest build() {
            return new ListAttacksRequest(this);
        }
    }

    public static interface Builder
    extends ShieldRequest.Builder,
    CopyableBuilder<Builder, ListAttacksRequest> {
        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder startTime(TimeRange var1);

        default public Builder startTime(Consumer<TimeRange.Builder> startTime) {
            return this.startTime((TimeRange)((TimeRange.Builder)TimeRange.builder().apply(startTime)).build());
        }

        public Builder endTime(TimeRange var1);

        default public Builder endTime(Consumer<TimeRange.Builder> endTime) {
            return this.endTime((TimeRange)((TimeRange.Builder)TimeRange.builder().apply(endTime)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

