/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.shield.model.TimeRange;

public class TimeRangeUnmarshaller
implements Unmarshaller<TimeRange, JsonUnmarshallerContext> {
    private static final TimeRangeUnmarshaller INSTANCE = new TimeRangeUnmarshaller();

    public TimeRange unmarshall(JsonUnmarshallerContext context) throws Exception {
        TimeRange.Builder timeRangeBuilder = TimeRange.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("FromInclusive", targetDepth)) {
                    context.nextToken();
                    timeRangeBuilder.fromInclusive((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("ToExclusive", targetDepth)) {
                    context.nextToken();
                    timeRangeBuilder.toExclusive((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TimeRange)timeRangeBuilder.build();
    }

    public static TimeRangeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

