/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.shield.model.Mitigation;
import software.amazon.awssdk.services.shield.model.MitigationListCopier;
import software.amazon.awssdk.services.shield.model.SubResourceSummary;
import software.amazon.awssdk.services.shield.model.SubResourceSummaryListCopier;
import software.amazon.awssdk.services.shield.model.SummarizedCounter;
import software.amazon.awssdk.services.shield.model.SummarizedCounterListCopier;
import software.amazon.awssdk.services.shield.transform.AttackDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttackDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, AttackDetail> {
    private final String attackId;
    private final String resourceArn;
    private final List<SubResourceSummary> subResources;
    private final Instant startTime;
    private final Instant endTime;
    private final List<SummarizedCounter> attackCounters;
    private final List<Mitigation> mitigations;

    private AttackDetail(BuilderImpl builder) {
        this.attackId = builder.attackId;
        this.resourceArn = builder.resourceArn;
        this.subResources = builder.subResources;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.attackCounters = builder.attackCounters;
        this.mitigations = builder.mitigations;
    }

    public String attackId() {
        return this.attackId;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public List<SubResourceSummary> subResources() {
        return this.subResources;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public List<SummarizedCounter> attackCounters() {
        return this.attackCounters;
    }

    public List<Mitigation> mitigations() {
        return this.mitigations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attackId() == null ? 0 : this.attackId().hashCode());
        hashCode = 31 * hashCode + (this.resourceArn() == null ? 0 : this.resourceArn().hashCode());
        hashCode = 31 * hashCode + (this.subResources() == null ? 0 : this.subResources().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.attackCounters() == null ? 0 : this.attackCounters().hashCode());
        hashCode = 31 * hashCode + (this.mitigations() == null ? 0 : this.mitigations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackDetail)) {
            return false;
        }
        AttackDetail other = (AttackDetail)obj;
        if (other.attackId() == null ^ this.attackId() == null) {
            return false;
        }
        if (other.attackId() != null && !other.attackId().equals(this.attackId())) {
            return false;
        }
        if (other.resourceArn() == null ^ this.resourceArn() == null) {
            return false;
        }
        if (other.resourceArn() != null && !other.resourceArn().equals(this.resourceArn())) {
            return false;
        }
        if (other.subResources() == null ^ this.subResources() == null) {
            return false;
        }
        if (other.subResources() != null && !other.subResources().equals(this.subResources())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.attackCounters() == null ^ this.attackCounters() == null) {
            return false;
        }
        if (other.attackCounters() != null && !other.attackCounters().equals(this.attackCounters())) {
            return false;
        }
        if (other.mitigations() == null ^ this.mitigations() == null) {
            return false;
        }
        return other.mitigations() == null || other.mitigations().equals(this.mitigations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attackId() != null) {
            sb.append("AttackId: ").append(this.attackId()).append(",");
        }
        if (this.resourceArn() != null) {
            sb.append("ResourceArn: ").append(this.resourceArn()).append(",");
        }
        if (this.subResources() != null) {
            sb.append("SubResources: ").append(this.subResources()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.attackCounters() != null) {
            sb.append("AttackCounters: ").append(this.attackCounters()).append(",");
        }
        if (this.mitigations() != null) {
            sb.append("Mitigations: ").append(this.mitigations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttackDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String attackId;
        private String resourceArn;
        private List<SubResourceSummary> subResources;
        private Instant startTime;
        private Instant endTime;
        private List<SummarizedCounter> attackCounters;
        private List<Mitigation> mitigations;

        private BuilderImpl() {
        }

        private BuilderImpl(AttackDetail model) {
            this.setAttackId(model.attackId);
            this.setResourceArn(model.resourceArn);
            this.setSubResources(model.subResources);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setAttackCounters(model.attackCounters);
            this.setMitigations(model.mitigations);
        }

        public final String getAttackId() {
            return this.attackId;
        }

        @Override
        public final Builder attackId(String attackId) {
            this.attackId = attackId;
            return this;
        }

        public final void setAttackId(String attackId) {
            this.attackId = attackId;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<SubResourceSummary> getSubResources() {
            return this.subResources;
        }

        @Override
        public final Builder subResources(Collection<SubResourceSummary> subResources) {
            this.subResources = SubResourceSummaryListCopier.copy(subResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subResources(SubResourceSummary ... subResources) {
            this.subResources(Arrays.asList(subResources));
            return this;
        }

        public final void setSubResources(Collection<SubResourceSummary> subResources) {
            this.subResources = SubResourceSummaryListCopier.copy(subResources);
        }

        @SafeVarargs
        public final void setSubResources(SubResourceSummary ... subResources) {
            this.subResources(Arrays.asList(subResources));
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<SummarizedCounter> getAttackCounters() {
            return this.attackCounters;
        }

        @Override
        public final Builder attackCounters(Collection<SummarizedCounter> attackCounters) {
            this.attackCounters = SummarizedCounterListCopier.copy(attackCounters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackCounters(SummarizedCounter ... attackCounters) {
            this.attackCounters(Arrays.asList(attackCounters));
            return this;
        }

        public final void setAttackCounters(Collection<SummarizedCounter> attackCounters) {
            this.attackCounters = SummarizedCounterListCopier.copy(attackCounters);
        }

        @SafeVarargs
        public final void setAttackCounters(SummarizedCounter ... attackCounters) {
            this.attackCounters(Arrays.asList(attackCounters));
        }

        public final Collection<Mitigation> getMitigations() {
            return this.mitigations;
        }

        @Override
        public final Builder mitigations(Collection<Mitigation> mitigations) {
            this.mitigations = MitigationListCopier.copy(mitigations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mitigations(Mitigation ... mitigations) {
            this.mitigations(Arrays.asList(mitigations));
            return this;
        }

        public final void setMitigations(Collection<Mitigation> mitigations) {
            this.mitigations = MitigationListCopier.copy(mitigations);
        }

        @SafeVarargs
        public final void setMitigations(Mitigation ... mitigations) {
            this.mitigations(Arrays.asList(mitigations));
        }

        public AttackDetail build() {
            return new AttackDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttackDetail> {
        public Builder attackId(String var1);

        public Builder resourceArn(String var1);

        public Builder subResources(Collection<SubResourceSummary> var1);

        public Builder subResources(SubResourceSummary ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder attackCounters(Collection<SummarizedCounter> var1);

        public Builder attackCounters(SummarizedCounter ... var1);

        public Builder mitigations(Collection<Mitigation> var1);

        public Builder mitigations(Mitigation ... var1);
    }
}

