/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AttackPropertyIdentifier {
    DESTINATION_URL("DESTINATION_URL"),
    REFERRER("REFERRER"),
    SOURCE_ASN("SOURCE_ASN"),
    SOURCE_COUNTRY("SOURCE_COUNTRY"),
    SOURCE_IP_ADDRESS("SOURCE_IP_ADDRESS"),
    SOURCE_USER_AGENT("SOURCE_USER_AGENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AttackPropertyIdentifier(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AttackPropertyIdentifier fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AttackPropertyIdentifier.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AttackPropertyIdentifier> knownValues() {
        return Stream.of(AttackPropertyIdentifier.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

