/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.ExportSourceType;
import software.amazon.awssdk.services.sesv2.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportJobSummary> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(ExportJobSummary.getter(ExportJobSummary::jobId)).setter(ExportJobSummary.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> EXPORT_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportSourceType").getter(ExportJobSummary.getter(ExportJobSummary::exportSourceTypeAsString)).setter(ExportJobSummary.setter(Builder::exportSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSourceType").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(ExportJobSummary.getter(ExportJobSummary::jobStatusAsString)).setter(ExportJobSummary.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(ExportJobSummary.getter(ExportJobSummary::createdTimestamp)).setter(ExportJobSummary.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> COMPLETED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedTimestamp").getter(ExportJobSummary.getter(ExportJobSummary::completedTimestamp)).setter(ExportJobSummary.setter(Builder::completedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, EXPORT_SOURCE_TYPE_FIELD, JOB_STATUS_FIELD, CREATED_TIMESTAMP_FIELD, COMPLETED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportJobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String exportSourceType;
    private final String jobStatus;
    private final Instant createdTimestamp;
    private final Instant completedTimestamp;

    private ExportJobSummary(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.exportSourceType = builder.exportSourceType;
        this.jobStatus = builder.jobStatus;
        this.createdTimestamp = builder.createdTimestamp;
        this.completedTimestamp = builder.completedTimestamp;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final ExportSourceType exportSourceType() {
        return ExportSourceType.fromValue(this.exportSourceType);
    }

    public final String exportSourceTypeAsString() {
        return this.exportSourceType;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant completedTimestamp() {
        return this.completedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportJobSummary)) {
            return false;
        }
        ExportJobSummary other = (ExportJobSummary)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.exportSourceTypeAsString(), other.exportSourceTypeAsString()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.completedTimestamp(), other.completedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"ExportJobSummary").add("JobId", (Object)this.jobId()).add("ExportSourceType", (Object)this.exportSourceTypeAsString()).add("JobStatus", (Object)this.jobStatusAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("CompletedTimestamp", (Object)this.completedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "ExportSourceType": {
                return Optional.ofNullable(clazz.cast(this.exportSourceTypeAsString()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "CompletedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.completedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("ExportSourceType", EXPORT_SOURCE_TYPE_FIELD);
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("CompletedTimestamp", COMPLETED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportJobSummary, T> g) {
        return obj -> g.apply((ExportJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String exportSourceType;
        private String jobStatus;
        private Instant createdTimestamp;
        private Instant completedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportJobSummary model) {
            this.jobId(model.jobId);
            this.exportSourceType(model.exportSourceType);
            this.jobStatus(model.jobStatus);
            this.createdTimestamp(model.createdTimestamp);
            this.completedTimestamp(model.completedTimestamp);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getExportSourceType() {
            return this.exportSourceType;
        }

        public final void setExportSourceType(String exportSourceType) {
            this.exportSourceType = exportSourceType;
        }

        @Override
        public final Builder exportSourceType(String exportSourceType) {
            this.exportSourceType = exportSourceType;
            return this;
        }

        @Override
        public final Builder exportSourceType(ExportSourceType exportSourceType) {
            this.exportSourceType(exportSourceType == null ? null : exportSourceType.toString());
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getCompletedTimestamp() {
            return this.completedTimestamp;
        }

        public final void setCompletedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
        }

        @Override
        public final Builder completedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
            return this;
        }

        public ExportJobSummary build() {
            return new ExportJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportJobSummary> {
        public Builder jobId(String var1);

        public Builder exportSourceType(String var1);

        public Builder exportSourceType(ExportSourceType var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder createdTimestamp(Instant var1);

        public Builder completedTimestamp(Instant var1);
    }
}

