/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.Destination;
import software.amazon.awssdk.services.sesv2.model.MessageHeader;
import software.amazon.awssdk.services.sesv2.model.MessageHeaderListCopier;
import software.amazon.awssdk.services.sesv2.model.MessageTag;
import software.amazon.awssdk.services.sesv2.model.MessageTagListCopier;
import software.amazon.awssdk.services.sesv2.model.ReplacementEmailContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BulkEmailEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BulkEmailEntry> {
    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(BulkEmailEntry.getter(BulkEmailEntry::destination)).setter(BulkEmailEntry.setter(Builder::destination)).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<List<MessageTag>> REPLACEMENT_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplacementTags").getter(BulkEmailEntry.getter(BulkEmailEntry::replacementTags)).setter(BulkEmailEntry.setter(Builder::replacementTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ReplacementEmailContent> REPLACEMENT_EMAIL_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplacementEmailContent").getter(BulkEmailEntry.getter(BulkEmailEntry::replacementEmailContent)).setter(BulkEmailEntry.setter(Builder::replacementEmailContent)).constructor(ReplacementEmailContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementEmailContent").build()}).build();
    private static final SdkField<List<MessageHeader>> REPLACEMENT_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplacementHeaders").getter(BulkEmailEntry.getter(BulkEmailEntry::replacementHeaders)).setter(BulkEmailEntry.setter(Builder::replacementHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD, REPLACEMENT_TAGS_FIELD, REPLACEMENT_EMAIL_CONTENT_FIELD, REPLACEMENT_HEADERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Destination destination;
    private final List<MessageTag> replacementTags;
    private final ReplacementEmailContent replacementEmailContent;
    private final List<MessageHeader> replacementHeaders;

    private BulkEmailEntry(BuilderImpl builder) {
        this.destination = builder.destination;
        this.replacementTags = builder.replacementTags;
        this.replacementEmailContent = builder.replacementEmailContent;
        this.replacementHeaders = builder.replacementHeaders;
    }

    public final Destination destination() {
        return this.destination;
    }

    public final boolean hasReplacementTags() {
        return this.replacementTags != null && !(this.replacementTags instanceof SdkAutoConstructList);
    }

    public final List<MessageTag> replacementTags() {
        return this.replacementTags;
    }

    public final ReplacementEmailContent replacementEmailContent() {
        return this.replacementEmailContent;
    }

    public final boolean hasReplacementHeaders() {
        return this.replacementHeaders != null && !(this.replacementHeaders instanceof SdkAutoConstructList);
    }

    public final List<MessageHeader> replacementHeaders() {
        return this.replacementHeaders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplacementTags() ? this.replacementTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replacementEmailContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplacementHeaders() ? this.replacementHeaders() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkEmailEntry)) {
            return false;
        }
        BulkEmailEntry other = (BulkEmailEntry)obj;
        return Objects.equals(this.destination(), other.destination()) && this.hasReplacementTags() == other.hasReplacementTags() && Objects.equals(this.replacementTags(), other.replacementTags()) && Objects.equals(this.replacementEmailContent(), other.replacementEmailContent()) && this.hasReplacementHeaders() == other.hasReplacementHeaders() && Objects.equals(this.replacementHeaders(), other.replacementHeaders());
    }

    public final String toString() {
        return ToString.builder((String)"BulkEmailEntry").add("Destination", (Object)this.destination()).add("ReplacementTags", this.hasReplacementTags() ? this.replacementTags() : null).add("ReplacementEmailContent", (Object)this.replacementEmailContent()).add("ReplacementHeaders", this.hasReplacementHeaders() ? this.replacementHeaders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "ReplacementTags": {
                return Optional.ofNullable(clazz.cast(this.replacementTags()));
            }
            case "ReplacementEmailContent": {
                return Optional.ofNullable(clazz.cast(this.replacementEmailContent()));
            }
            case "ReplacementHeaders": {
                return Optional.ofNullable(clazz.cast(this.replacementHeaders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BulkEmailEntry, T> g) {
        return obj -> g.apply((BulkEmailEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Destination destination;
        private List<MessageTag> replacementTags = DefaultSdkAutoConstructList.getInstance();
        private ReplacementEmailContent replacementEmailContent;
        private List<MessageHeader> replacementHeaders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BulkEmailEntry model) {
            this.destination(model.destination);
            this.replacementTags(model.replacementTags);
            this.replacementEmailContent(model.replacementEmailContent);
            this.replacementHeaders(model.replacementHeaders);
        }

        public final Destination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final List<MessageTag.Builder> getReplacementTags() {
            List<MessageTag.Builder> result = MessageTagListCopier.copyToBuilder(this.replacementTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplacementTags(Collection<MessageTag.BuilderImpl> replacementTags) {
            this.replacementTags = MessageTagListCopier.copyFromBuilder(replacementTags);
        }

        @Override
        public final Builder replacementTags(Collection<MessageTag> replacementTags) {
            this.replacementTags = MessageTagListCopier.copy(replacementTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacementTags(MessageTag ... replacementTags) {
            this.replacementTags(Arrays.asList(replacementTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacementTags(Consumer<MessageTag.Builder> ... replacementTags) {
            this.replacementTags(Stream.of(replacementTags).map(c -> (MessageTag)((MessageTag.Builder)MessageTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ReplacementEmailContent.Builder getReplacementEmailContent() {
            return this.replacementEmailContent != null ? this.replacementEmailContent.toBuilder() : null;
        }

        public final void setReplacementEmailContent(ReplacementEmailContent.BuilderImpl replacementEmailContent) {
            this.replacementEmailContent = replacementEmailContent != null ? replacementEmailContent.build() : null;
        }

        @Override
        public final Builder replacementEmailContent(ReplacementEmailContent replacementEmailContent) {
            this.replacementEmailContent = replacementEmailContent;
            return this;
        }

        public final List<MessageHeader.Builder> getReplacementHeaders() {
            List<MessageHeader.Builder> result = MessageHeaderListCopier.copyToBuilder(this.replacementHeaders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplacementHeaders(Collection<MessageHeader.BuilderImpl> replacementHeaders) {
            this.replacementHeaders = MessageHeaderListCopier.copyFromBuilder(replacementHeaders);
        }

        @Override
        public final Builder replacementHeaders(Collection<MessageHeader> replacementHeaders) {
            this.replacementHeaders = MessageHeaderListCopier.copy(replacementHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacementHeaders(MessageHeader ... replacementHeaders) {
            this.replacementHeaders(Arrays.asList(replacementHeaders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacementHeaders(Consumer<MessageHeader.Builder> ... replacementHeaders) {
            this.replacementHeaders(Stream.of(replacementHeaders).map(c -> (MessageHeader)((MessageHeader.Builder)MessageHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BulkEmailEntry build() {
            return new BulkEmailEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BulkEmailEntry> {
        public Builder destination(Destination var1);

        default public Builder destination(Consumer<Destination.Builder> destination) {
            return this.destination((Destination)((Destination.Builder)Destination.builder().applyMutation(destination)).build());
        }

        public Builder replacementTags(Collection<MessageTag> var1);

        public Builder replacementTags(MessageTag ... var1);

        public Builder replacementTags(Consumer<MessageTag.Builder> ... var1);

        public Builder replacementEmailContent(ReplacementEmailContent var1);

        default public Builder replacementEmailContent(Consumer<ReplacementEmailContent.Builder> replacementEmailContent) {
            return this.replacementEmailContent((ReplacementEmailContent)((ReplacementEmailContent.Builder)ReplacementEmailContent.builder().applyMutation(replacementEmailContent)).build());
        }

        public Builder replacementHeaders(Collection<MessageHeader> var1);

        public Builder replacementHeaders(MessageHeader ... var1);

        public Builder replacementHeaders(Consumer<MessageHeader.Builder> ... var1);
    }
}

