/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.AddHeaderAction;
import software.amazon.awssdk.services.ses.model.BounceAction;
import software.amazon.awssdk.services.ses.model.LambdaAction;
import software.amazon.awssdk.services.ses.model.S3Action;
import software.amazon.awssdk.services.ses.model.SNSAction;
import software.amazon.awssdk.services.ses.model.StopAction;
import software.amazon.awssdk.services.ses.model.WorkmailAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReceiptAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReceiptAction> {
    private static final SdkField<S3Action> S3_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReceiptAction.getter(ReceiptAction::s3Action)).setter(ReceiptAction.setter(Builder::s3Action)).constructor(S3Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Action").build()}).build();
    private static final SdkField<BounceAction> BOUNCE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReceiptAction.getter(ReceiptAction::bounceAction)).setter(ReceiptAction.setter(Builder::bounceAction)).constructor(BounceAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BounceAction").build()}).build();
    private static final SdkField<WorkmailAction> WORKMAIL_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReceiptAction.getter(ReceiptAction::workmailAction)).setter(ReceiptAction.setter(Builder::workmailAction)).constructor(WorkmailAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkmailAction").build()}).build();
    private static final SdkField<LambdaAction> LAMBDA_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReceiptAction.getter(ReceiptAction::lambdaAction)).setter(ReceiptAction.setter(Builder::lambdaAction)).constructor(LambdaAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaAction").build()}).build();
    private static final SdkField<StopAction> STOP_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReceiptAction.getter(ReceiptAction::stopAction)).setter(ReceiptAction.setter(Builder::stopAction)).constructor(StopAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopAction").build()}).build();
    private static final SdkField<AddHeaderAction> ADD_HEADER_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReceiptAction.getter(ReceiptAction::addHeaderAction)).setter(ReceiptAction.setter(Builder::addHeaderAction)).constructor(AddHeaderAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddHeaderAction").build()}).build();
    private static final SdkField<SNSAction> SNS_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReceiptAction.getter(ReceiptAction::snsAction)).setter(ReceiptAction.setter(Builder::snsAction)).constructor(SNSAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ACTION_FIELD, BOUNCE_ACTION_FIELD, WORKMAIL_ACTION_FIELD, LAMBDA_ACTION_FIELD, STOP_ACTION_FIELD, ADD_HEADER_ACTION_FIELD, SNS_ACTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final S3Action s3Action;
    private final BounceAction bounceAction;
    private final WorkmailAction workmailAction;
    private final LambdaAction lambdaAction;
    private final StopAction stopAction;
    private final AddHeaderAction addHeaderAction;
    private final SNSAction snsAction;

    private ReceiptAction(BuilderImpl builder) {
        this.s3Action = builder.s3Action;
        this.bounceAction = builder.bounceAction;
        this.workmailAction = builder.workmailAction;
        this.lambdaAction = builder.lambdaAction;
        this.stopAction = builder.stopAction;
        this.addHeaderAction = builder.addHeaderAction;
        this.snsAction = builder.snsAction;
    }

    public S3Action s3Action() {
        return this.s3Action;
    }

    public BounceAction bounceAction() {
        return this.bounceAction;
    }

    public WorkmailAction workmailAction() {
        return this.workmailAction;
    }

    public LambdaAction lambdaAction() {
        return this.lambdaAction;
    }

    public StopAction stopAction() {
        return this.stopAction;
    }

    public AddHeaderAction addHeaderAction() {
        return this.addHeaderAction;
    }

    public SNSAction snsAction() {
        return this.snsAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Action());
        hashCode = 31 * hashCode + Objects.hashCode(this.bounceAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.workmailAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.addHeaderAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsAction());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptAction)) {
            return false;
        }
        ReceiptAction other = (ReceiptAction)obj;
        return Objects.equals(this.s3Action(), other.s3Action()) && Objects.equals(this.bounceAction(), other.bounceAction()) && Objects.equals(this.workmailAction(), other.workmailAction()) && Objects.equals(this.lambdaAction(), other.lambdaAction()) && Objects.equals(this.stopAction(), other.stopAction()) && Objects.equals(this.addHeaderAction(), other.addHeaderAction()) && Objects.equals(this.snsAction(), other.snsAction());
    }

    public String toString() {
        return ToString.builder((String)"ReceiptAction").add("S3Action", (Object)this.s3Action()).add("BounceAction", (Object)this.bounceAction()).add("WorkmailAction", (Object)this.workmailAction()).add("LambdaAction", (Object)this.lambdaAction()).add("StopAction", (Object)this.stopAction()).add("AddHeaderAction", (Object)this.addHeaderAction()).add("SNSAction", (Object)this.snsAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Action": {
                return Optional.ofNullable(clazz.cast(this.s3Action()));
            }
            case "BounceAction": {
                return Optional.ofNullable(clazz.cast(this.bounceAction()));
            }
            case "WorkmailAction": {
                return Optional.ofNullable(clazz.cast(this.workmailAction()));
            }
            case "LambdaAction": {
                return Optional.ofNullable(clazz.cast(this.lambdaAction()));
            }
            case "StopAction": {
                return Optional.ofNullable(clazz.cast(this.stopAction()));
            }
            case "AddHeaderAction": {
                return Optional.ofNullable(clazz.cast(this.addHeaderAction()));
            }
            case "SNSAction": {
                return Optional.ofNullable(clazz.cast(this.snsAction()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReceiptAction, T> g) {
        return obj -> g.apply((ReceiptAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Action s3Action;
        private BounceAction bounceAction;
        private WorkmailAction workmailAction;
        private LambdaAction lambdaAction;
        private StopAction stopAction;
        private AddHeaderAction addHeaderAction;
        private SNSAction snsAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptAction model) {
            this.s3Action(model.s3Action);
            this.bounceAction(model.bounceAction);
            this.workmailAction(model.workmailAction);
            this.lambdaAction(model.lambdaAction);
            this.stopAction(model.stopAction);
            this.addHeaderAction(model.addHeaderAction);
            this.snsAction(model.snsAction);
        }

        public final S3Action.Builder getS3Action() {
            return this.s3Action != null ? this.s3Action.toBuilder() : null;
        }

        @Override
        public final Builder s3Action(S3Action s3Action) {
            this.s3Action = s3Action;
            return this;
        }

        public final void setS3Action(S3Action.BuilderImpl s3Action) {
            this.s3Action = s3Action != null ? s3Action.build() : null;
        }

        public final BounceAction.Builder getBounceAction() {
            return this.bounceAction != null ? this.bounceAction.toBuilder() : null;
        }

        @Override
        public final Builder bounceAction(BounceAction bounceAction) {
            this.bounceAction = bounceAction;
            return this;
        }

        public final void setBounceAction(BounceAction.BuilderImpl bounceAction) {
            this.bounceAction = bounceAction != null ? bounceAction.build() : null;
        }

        public final WorkmailAction.Builder getWorkmailAction() {
            return this.workmailAction != null ? this.workmailAction.toBuilder() : null;
        }

        @Override
        public final Builder workmailAction(WorkmailAction workmailAction) {
            this.workmailAction = workmailAction;
            return this;
        }

        public final void setWorkmailAction(WorkmailAction.BuilderImpl workmailAction) {
            this.workmailAction = workmailAction != null ? workmailAction.build() : null;
        }

        public final LambdaAction.Builder getLambdaAction() {
            return this.lambdaAction != null ? this.lambdaAction.toBuilder() : null;
        }

        @Override
        public final Builder lambdaAction(LambdaAction lambdaAction) {
            this.lambdaAction = lambdaAction;
            return this;
        }

        public final void setLambdaAction(LambdaAction.BuilderImpl lambdaAction) {
            this.lambdaAction = lambdaAction != null ? lambdaAction.build() : null;
        }

        public final StopAction.Builder getStopAction() {
            return this.stopAction != null ? this.stopAction.toBuilder() : null;
        }

        @Override
        public final Builder stopAction(StopAction stopAction) {
            this.stopAction = stopAction;
            return this;
        }

        public final void setStopAction(StopAction.BuilderImpl stopAction) {
            this.stopAction = stopAction != null ? stopAction.build() : null;
        }

        public final AddHeaderAction.Builder getAddHeaderAction() {
            return this.addHeaderAction != null ? this.addHeaderAction.toBuilder() : null;
        }

        @Override
        public final Builder addHeaderAction(AddHeaderAction addHeaderAction) {
            this.addHeaderAction = addHeaderAction;
            return this;
        }

        public final void setAddHeaderAction(AddHeaderAction.BuilderImpl addHeaderAction) {
            this.addHeaderAction = addHeaderAction != null ? addHeaderAction.build() : null;
        }

        public final SNSAction.Builder getSnsAction() {
            return this.snsAction != null ? this.snsAction.toBuilder() : null;
        }

        @Override
        public final Builder snsAction(SNSAction snsAction) {
            this.snsAction = snsAction;
            return this;
        }

        public final void setSnsAction(SNSAction.BuilderImpl snsAction) {
            this.snsAction = snsAction != null ? snsAction.build() : null;
        }

        public ReceiptAction build() {
            return new ReceiptAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReceiptAction> {
        public Builder s3Action(S3Action var1);

        default public Builder s3Action(Consumer<S3Action.Builder> s3Action) {
            return this.s3Action((S3Action)((S3Action.Builder)S3Action.builder().applyMutation(s3Action)).build());
        }

        public Builder bounceAction(BounceAction var1);

        default public Builder bounceAction(Consumer<BounceAction.Builder> bounceAction) {
            return this.bounceAction((BounceAction)((BounceAction.Builder)BounceAction.builder().applyMutation(bounceAction)).build());
        }

        public Builder workmailAction(WorkmailAction var1);

        default public Builder workmailAction(Consumer<WorkmailAction.Builder> workmailAction) {
            return this.workmailAction((WorkmailAction)((WorkmailAction.Builder)WorkmailAction.builder().applyMutation(workmailAction)).build());
        }

        public Builder lambdaAction(LambdaAction var1);

        default public Builder lambdaAction(Consumer<LambdaAction.Builder> lambdaAction) {
            return this.lambdaAction((LambdaAction)((LambdaAction.Builder)LambdaAction.builder().applyMutation(lambdaAction)).build());
        }

        public Builder stopAction(StopAction var1);

        default public Builder stopAction(Consumer<StopAction.Builder> stopAction) {
            return this.stopAction((StopAction)((StopAction.Builder)StopAction.builder().applyMutation(stopAction)).build());
        }

        public Builder addHeaderAction(AddHeaderAction var1);

        default public Builder addHeaderAction(Consumer<AddHeaderAction.Builder> addHeaderAction) {
            return this.addHeaderAction((AddHeaderAction)((AddHeaderAction.Builder)AddHeaderAction.builder().applyMutation(addHeaderAction)).build());
        }

        public Builder snsAction(SNSAction var1);

        default public Builder snsAction(Consumer<SNSAction.Builder> snsAction) {
            return this.snsAction((SNSAction)((SNSAction.Builder)SNSAction.builder().applyMutation(snsAction)).build());
        }
    }
}

