/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse;

public class ListLaunchPathsIterable
implements SdkIterable<ListLaunchPathsResponse> {
    private final ServiceCatalogClient client;
    private final ListLaunchPathsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLaunchPathsIterable(ServiceCatalogClient client, ListLaunchPathsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLaunchPathsResponseFetcher();
    }

    public Iterator<ListLaunchPathsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListLaunchPathsIterable resume(ListLaunchPathsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListLaunchPathsIterable(this.client, (ListLaunchPathsRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new ListLaunchPathsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListLaunchPathsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListLaunchPathsResponseFetcher
    implements SyncPageFetcher<ListLaunchPathsResponse> {
        private ListLaunchPathsResponseFetcher() {
        }

        public boolean hasNextPage(ListLaunchPathsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListLaunchPathsResponse nextPage(ListLaunchPathsResponse previousPage) {
            if (previousPage == null) {
                return ListLaunchPathsIterable.this.client.listLaunchPaths(ListLaunchPathsIterable.this.firstRequest);
            }
            return ListLaunchPathsIterable.this.client.listLaunchPaths((ListLaunchPathsRequest)((Object)ListLaunchPathsIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

