/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetail;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProvisioningArtifactsResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListProvisioningArtifactsResponse> {
    private static final SdkField<List<ProvisioningArtifactDetail>> PROVISIONING_ARTIFACT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListProvisioningArtifactsResponse.getter(ListProvisioningArtifactsResponse::provisioningArtifactDetails)).setter(ListProvisioningArtifactsResponse.setter(Builder::provisioningArtifactDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisioningArtifactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListProvisioningArtifactsResponse.getter(ListProvisioningArtifactsResponse::nextPageToken)).setter(ListProvisioningArtifactsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONING_ARTIFACT_DETAILS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<ProvisioningArtifactDetail> provisioningArtifactDetails;
    private final String nextPageToken;

    private ListProvisioningArtifactsResponse(BuilderImpl builder) {
        super(builder);
        this.provisioningArtifactDetails = builder.provisioningArtifactDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    public boolean hasProvisioningArtifactDetails() {
        return this.provisioningArtifactDetails != null && !(this.provisioningArtifactDetails instanceof SdkAutoConstructList);
    }

    public List<ProvisioningArtifactDetail> provisioningArtifactDetails() {
        return this.provisioningArtifactDetails;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisioningArtifactsResponse)) {
            return false;
        }
        ListProvisioningArtifactsResponse other = (ListProvisioningArtifactsResponse)((Object)obj);
        return Objects.equals(this.provisioningArtifactDetails(), other.provisioningArtifactDetails()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListProvisioningArtifactsResponse").add("ProvisioningArtifactDetails", this.provisioningArtifactDetails()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisioningArtifactDetails": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactDetails()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProvisioningArtifactsResponse, T> g) {
        return obj -> g.apply((ListProvisioningArtifactsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ProvisioningArtifactDetail> provisioningArtifactDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisioningArtifactsResponse model) {
            super(model);
            this.provisioningArtifactDetails(model.provisioningArtifactDetails);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ProvisioningArtifactDetail.Builder> getProvisioningArtifactDetails() {
            return this.provisioningArtifactDetails != null ? (Collection)this.provisioningArtifactDetails.stream().map(ProvisioningArtifactDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningArtifactDetails(Collection<ProvisioningArtifactDetail> provisioningArtifactDetails) {
            this.provisioningArtifactDetails = ProvisioningArtifactDetailsCopier.copy(provisioningArtifactDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactDetails(ProvisioningArtifactDetail ... provisioningArtifactDetails) {
            this.provisioningArtifactDetails(Arrays.asList(provisioningArtifactDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactDetails(Consumer<ProvisioningArtifactDetail.Builder> ... provisioningArtifactDetails) {
            this.provisioningArtifactDetails(Stream.of(provisioningArtifactDetails).map(c -> (ProvisioningArtifactDetail)((ProvisioningArtifactDetail.Builder)ProvisioningArtifactDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningArtifactDetails(Collection<ProvisioningArtifactDetail.BuilderImpl> provisioningArtifactDetails) {
            this.provisioningArtifactDetails = ProvisioningArtifactDetailsCopier.copyFromBuilder(provisioningArtifactDetails);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListProvisioningArtifactsResponse build() {
            return new ListProvisioningArtifactsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProvisioningArtifactsResponse> {
        public Builder provisioningArtifactDetails(Collection<ProvisioningArtifactDetail> var1);

        public Builder provisioningArtifactDetails(ProvisioningArtifactDetail ... var1);

        public Builder provisioningArtifactDetails(Consumer<ProvisioningArtifactDetail.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

