/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils.service.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.http.AbortableCallable;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkRequestContext;

public final class MockHttpClient
implements SdkHttpClient {
    private final List<SdkHttpFullRequest> capturedRequests = new ArrayList<SdkHttpFullRequest>();
    private SdkHttpFullResponse nextResponse;

    public AbortableCallable<SdkHttpFullResponse> prepareRequest(SdkHttpFullRequest request, SdkRequestContext requestContext) {
        this.capturedRequests.add(request);
        return new AbortableCallable<SdkHttpFullResponse>(){

            public SdkHttpFullResponse call() throws Exception {
                return MockHttpClient.this.nextResponse;
            }

            public void abort() {
            }
        };
    }

    public <T> Optional<T> getConfigurationValue(SdkHttpConfigurationOption<T> key) {
        return Optional.empty();
    }

    public void close() {
    }

    public void reset() {
        this.capturedRequests.clear();
        this.nextResponse = null;
    }

    public void stubNextResponse(SdkHttpFullResponse nextResponse) {
        this.nextResponse = nextResponse;
    }

    public SdkHttpFullRequest getLastRequest() {
        if (this.capturedRequests.isEmpty()) {
            throw new IllegalStateException("No requests were captured by the mock");
        }
        return this.capturedRequests.get(this.capturedRequests.size() - 1);
    }
}

