/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationRequest extends ServerlessApplicationRepositoryRequest implements
        ToCopyableBuilder<UpdateApplicationRequest.Builder, UpdateApplicationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(UpdateApplicationRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> AUTHOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Author")
            .getter(getter(UpdateApplicationRequest::author)).setter(setter(Builder::author))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("author").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateApplicationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> HOME_PAGE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomePageUrl").getter(getter(UpdateApplicationRequest::homePageUrl)).setter(setter(Builder::homePageUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("homePageUrl").build()).build();

    private static final SdkField<List<String>> LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Labels")
            .getter(getter(UpdateApplicationRequest::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> README_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReadmeBody").getter(getter(UpdateApplicationRequest::readmeBody)).setter(setter(Builder::readmeBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeBody").build()).build();

    private static final SdkField<String> README_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReadmeUrl").getter(getter(UpdateApplicationRequest::readmeUrl)).setter(setter(Builder::readmeUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            AUTHOR_FIELD, DESCRIPTION_FIELD, HOME_PAGE_URL_FIELD, LABELS_FIELD, README_BODY_FIELD, README_URL_FIELD));

    private final String applicationId;

    private final String author;

    private final String description;

    private final String homePageUrl;

    private final List<String> labels;

    private final String readmeBody;

    private final String readmeUrl;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.author = builder.author;
        this.description = builder.description;
        this.homePageUrl = builder.homePageUrl;
        this.labels = builder.labels;
        this.readmeBody = builder.readmeBody;
        this.readmeUrl = builder.readmeUrl;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The name of the author publishing the app.
     * </p>
     * <p>
     * Minimum length=1. Maximum length=127.
     * </p>
     * <p>
     * Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
     * </p>
     * 
     * @return The name of the author publishing the app.</p>
     *         <p>
     *         Minimum length=1. Maximum length=127.
     *         </p>
     *         <p>
     *         Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
     */
    public final String author() {
        return author;
    }

    /**
     * <p>
     * The description of the application.
     * </p>
     * <p>
     * Minimum length=1. Maximum length=256
     * </p>
     * 
     * @return The description of the application.</p>
     *         <p>
     *         Minimum length=1. Maximum length=256
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A URL with more information about the application, for example the location of your GitHub repository for the
     * application.
     * </p>
     * 
     * @return A URL with more information about the application, for example the location of your GitHub repository for
     *         the application.
     */
    public final String homePageUrl() {
        return homePageUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Labels to improve discovery of apps in search results.
     * </p>
     * <p>
     * Minimum length=1. Maximum length=127. Maximum number of labels: 10
     * </p>
     * <p>
     * Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return Labels to improve discovery of apps in search results.</p>
     *         <p>
     *         Minimum length=1. Maximum length=127. Maximum number of labels: 10
     *         </p>
     *         <p>
     *         Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
     */
    public final List<String> labels() {
        return labels;
    }

    /**
     * <p>
     * A text readme file in Markdown language that contains a more detailed description of the application and how it
     * works.
     * </p>
     * <p>
     * Maximum size 5 MB
     * </p>
     * 
     * @return A text readme file in Markdown language that contains a more detailed description of the application and
     *         how it works.</p>
     *         <p>
     *         Maximum size 5 MB
     */
    public final String readmeBody() {
        return readmeBody;
    }

    /**
     * <p>
     * A link to the readme file in Markdown language that contains a more detailed description of the application and
     * how it works.
     * </p>
     * <p>
     * Maximum size 5 MB
     * </p>
     * 
     * @return A link to the readme file in Markdown language that contains a more detailed description of the
     *         application and how it works.</p>
     *         <p>
     *         Maximum size 5 MB
     */
    public final String readmeUrl() {
        return readmeUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(author());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(homePageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(readmeBody());
        hashCode = 31 * hashCode + Objects.hashCode(readmeUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(author(), other.author())
                && Objects.equals(description(), other.description()) && Objects.equals(homePageUrl(), other.homePageUrl())
                && hasLabels() == other.hasLabels() && Objects.equals(labels(), other.labels())
                && Objects.equals(readmeBody(), other.readmeBody()) && Objects.equals(readmeUrl(), other.readmeUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationRequest").add("ApplicationId", applicationId()).add("Author", author())
                .add("Description", description()).add("HomePageUrl", homePageUrl()).add("Labels", hasLabels() ? labels() : null)
                .add("ReadmeBody", readmeBody()).add("ReadmeUrl", readmeUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Author":
            return Optional.ofNullable(clazz.cast(author()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "HomePageUrl":
            return Optional.ofNullable(clazz.cast(homePageUrl()));
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "ReadmeBody":
            return Optional.ofNullable(clazz.cast(readmeBody()));
        case "ReadmeUrl":
            return Optional.ofNullable(clazz.cast(readmeUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServerlessApplicationRepositoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateApplicationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application.
         * </p>
         * 
         * @param applicationId
         *        The Amazon Resource Name (ARN) of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The name of the author publishing the app.
         * </p>
         * <p>
         * Minimum length=1. Maximum length=127.
         * </p>
         * <p>
         * Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
         * </p>
         * 
         * @param author
         *        The name of the author publishing the app.</p>
         *        <p>
         *        Minimum length=1. Maximum length=127.
         *        </p>
         *        <p>
         *        Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder author(String author);

        /**
         * <p>
         * The description of the application.
         * </p>
         * <p>
         * Minimum length=1. Maximum length=256
         * </p>
         * 
         * @param description
         *        The description of the application.</p>
         *        <p>
         *        Minimum length=1. Maximum length=256
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A URL with more information about the application, for example the location of your GitHub repository for the
         * application.
         * </p>
         * 
         * @param homePageUrl
         *        A URL with more information about the application, for example the location of your GitHub repository
         *        for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homePageUrl(String homePageUrl);

        /**
         * <p>
         * Labels to improve discovery of apps in search results.
         * </p>
         * <p>
         * Minimum length=1. Maximum length=127. Maximum number of labels: 10
         * </p>
         * <p>
         * Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * </p>
         * 
         * @param labels
         *        Labels to improve discovery of apps in search results.</p>
         *        <p>
         *        Minimum length=1. Maximum length=127. Maximum number of labels: 10
         *        </p>
         *        <p>
         *        Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<String> labels);

        /**
         * <p>
         * Labels to improve discovery of apps in search results.
         * </p>
         * <p>
         * Minimum length=1. Maximum length=127. Maximum number of labels: 10
         * </p>
         * <p>
         * Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * </p>
         * 
         * @param labels
         *        Labels to improve discovery of apps in search results.</p>
         *        <p>
         *        Minimum length=1. Maximum length=127. Maximum number of labels: 10
         *        </p>
         *        <p>
         *        Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(String... labels);

        /**
         * <p>
         * A text readme file in Markdown language that contains a more detailed description of the application and how
         * it works.
         * </p>
         * <p>
         * Maximum size 5 MB
         * </p>
         * 
         * @param readmeBody
         *        A text readme file in Markdown language that contains a more detailed description of the application
         *        and how it works.</p>
         *        <p>
         *        Maximum size 5 MB
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readmeBody(String readmeBody);

        /**
         * <p>
         * A link to the readme file in Markdown language that contains a more detailed description of the application
         * and how it works.
         * </p>
         * <p>
         * Maximum size 5 MB
         * </p>
         * 
         * @param readmeUrl
         *        A link to the readme file in Markdown language that contains a more detailed description of the
         *        application and how it works.</p>
         *        <p>
         *        Maximum size 5 MB
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readmeUrl(String readmeUrl);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String author;

        private String description;

        private String homePageUrl;

        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private String readmeBody;

        private String readmeUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            applicationId(model.applicationId);
            author(model.author);
            description(model.description);
            homePageUrl(model.homePageUrl);
            labels(model.labels);
            readmeBody(model.readmeBody);
            readmeUrl(model.readmeUrl);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getAuthor() {
            return author;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getHomePageUrl() {
            return homePageUrl;
        }

        public final void setHomePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
        }

        @Override
        public final Builder homePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
            return this;
        }

        public final Collection<String> getLabels() {
            if (labels instanceof SdkAutoConstructList) {
                return null;
            }
            return labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        public final String getReadmeBody() {
            return readmeBody;
        }

        public final void setReadmeBody(String readmeBody) {
            this.readmeBody = readmeBody;
        }

        @Override
        public final Builder readmeBody(String readmeBody) {
            this.readmeBody = readmeBody;
            return this;
        }

        public final String getReadmeUrl() {
            return readmeUrl;
        }

        public final void setReadmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
        }

        @Override
        public final Builder readmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
