/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.serverlessapplicationrepository.ServerlessApplicationRepositoryAsyncClient;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse;

public class ListApplicationVersionsPublisher
implements SdkPublisher<ListApplicationVersionsResponse> {
    private final ServerlessApplicationRepositoryAsyncClient client;
    private final ListApplicationVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationVersionsPublisher(ServerlessApplicationRepositoryAsyncClient client, ListApplicationVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationVersionsPublisher(ServerlessApplicationRepositoryAsyncClient client, ListApplicationVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListApplicationVersionsResponseFetcher
    implements AsyncPageFetcher<ListApplicationVersionsResponse> {
        private ListApplicationVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationVersionsResponse> nextPage(ListApplicationVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationVersionsPublisher.this.client.listApplicationVersions(ListApplicationVersionsPublisher.this.firstRequest);
            }
            return ListApplicationVersionsPublisher.this.client.listApplicationVersions((ListApplicationVersionsRequest)((Object)ListApplicationVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

