/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.serverlessapplicationrepository.transform.VersionSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VersionSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, VersionSummary> {
    private final String applicationId;
    private final String creationTime;
    private final String semanticVersion;
    private final String sourceCodeUrl;

    private VersionSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.creationTime = builder.creationTime;
        this.semanticVersion = builder.semanticVersion;
        this.sourceCodeUrl = builder.sourceCodeUrl;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String creationTime() {
        return this.creationTime;
    }

    public String semanticVersion() {
        return this.semanticVersion;
    }

    public String sourceCodeUrl() {
        return this.sourceCodeUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCodeUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionSummary)) {
            return false;
        }
        VersionSummary other = (VersionSummary)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && Objects.equals(this.sourceCodeUrl(), other.sourceCodeUrl());
    }

    public String toString() {
        return ToString.builder((String)"VersionSummary").add("ApplicationId", (Object)this.applicationId()).add("CreationTime", (Object)this.creationTime()).add("SemanticVersion", (Object)this.semanticVersion()).add("SourceCodeUrl", (Object)this.sourceCodeUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "SemanticVersion": {
                return Optional.ofNullable(clazz.cast(this.semanticVersion()));
            }
            case "SourceCodeUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceCodeUrl()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VersionSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String creationTime;
        private String semanticVersion;
        private String sourceCodeUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(VersionSummary model) {
            this.applicationId(model.applicationId);
            this.creationTime(model.creationTime);
            this.semanticVersion(model.semanticVersion);
            this.sourceCodeUrl(model.sourceCodeUrl);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getSourceCodeUrl() {
            return this.sourceCodeUrl;
        }

        @Override
        public final Builder sourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
            return this;
        }

        public final void setSourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
        }

        public VersionSummary build() {
            return new VersionSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VersionSummary> {
        public Builder applicationId(String var1);

        public Builder creationTime(String var1);

        public Builder semanticVersion(String var1);

        public Builder sourceCodeUrl(String var1);
    }
}

