/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationPolicyStatement;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOfApplicationPolicyStatementCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutApplicationPolicyRequest
extends ServerlessApplicationRepositoryRequest
implements ToCopyableBuilder<Builder, PutApplicationPolicyRequest> {
    private final String applicationId;
    private final List<ApplicationPolicyStatement> statements;

    private PutApplicationPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.statements = builder.statements;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public List<ApplicationPolicyStatement> statements() {
        return this.statements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statements());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutApplicationPolicyRequest)) {
            return false;
        }
        PutApplicationPolicyRequest other = (PutApplicationPolicyRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.statements(), other.statements());
    }

    public String toString() {
        return ToString.builder((String)"PutApplicationPolicyRequest").add("ApplicationId", (Object)this.applicationId()).add("Statements", this.statements()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Statements": {
                return Optional.ofNullable(clazz.cast(this.statements()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private List<ApplicationPolicyStatement> statements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutApplicationPolicyRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.statements(model.statements);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Collection<ApplicationPolicyStatement.Builder> getStatements() {
            return this.statements != null ? (Collection)this.statements.stream().map(ApplicationPolicyStatement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statements(Collection<ApplicationPolicyStatement> statements) {
            this.statements = ___listOfApplicationPolicyStatementCopier.copy(statements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(ApplicationPolicyStatement ... statements) {
            this.statements(Arrays.asList(statements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Consumer<ApplicationPolicyStatement.Builder> ... statements) {
            this.statements(Stream.of(statements).map(c -> (ApplicationPolicyStatement)((ApplicationPolicyStatement.Builder)ApplicationPolicyStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatements(Collection<ApplicationPolicyStatement.BuilderImpl> statements) {
            this.statements = ___listOfApplicationPolicyStatementCopier.copyFromBuilder(statements);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutApplicationPolicyRequest build() {
            return new PutApplicationPolicyRequest(this);
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryRequest.Builder,
    CopyableBuilder<Builder, PutApplicationPolicyRequest> {
        public Builder applicationId(String var1);

        public Builder statements(Collection<ApplicationPolicyStatement> var1);

        public Builder statements(ApplicationPolicyStatement ... var1);

        public Builder statements(Consumer<ApplicationPolicyStatement.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

