/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationRequest
extends ServerlessApplicationRepositoryRequest
implements ToCopyableBuilder<Builder, CreateApplicationRequest> {
    private final String author;
    private final String description;
    private final String homePageUrl;
    private final List<String> labels;
    private final String licenseBody;
    private final String licenseUrl;
    private final String name;
    private final String readmeBody;
    private final String readmeUrl;
    private final String semanticVersion;
    private final String sourceCodeUrl;
    private final String spdxLicenseId;
    private final String templateBody;
    private final String templateUrl;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.author = builder.author;
        this.description = builder.description;
        this.homePageUrl = builder.homePageUrl;
        this.labels = builder.labels;
        this.licenseBody = builder.licenseBody;
        this.licenseUrl = builder.licenseUrl;
        this.name = builder.name;
        this.readmeBody = builder.readmeBody;
        this.readmeUrl = builder.readmeUrl;
        this.semanticVersion = builder.semanticVersion;
        this.sourceCodeUrl = builder.sourceCodeUrl;
        this.spdxLicenseId = builder.spdxLicenseId;
        this.templateBody = builder.templateBody;
        this.templateUrl = builder.templateUrl;
    }

    public String author() {
        return this.author;
    }

    public String description() {
        return this.description;
    }

    public String homePageUrl() {
        return this.homePageUrl;
    }

    public List<String> labels() {
        return this.labels;
    }

    public String licenseBody() {
        return this.licenseBody;
    }

    public String licenseUrl() {
        return this.licenseUrl;
    }

    public String name() {
        return this.name;
    }

    public String readmeBody() {
        return this.readmeBody;
    }

    public String readmeUrl() {
        return this.readmeUrl;
    }

    public String semanticVersion() {
        return this.semanticVersion;
    }

    public String sourceCodeUrl() {
        return this.sourceCodeUrl;
    }

    public String spdxLicenseId() {
        return this.spdxLicenseId;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public String templateUrl() {
        return this.templateUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.author());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.homePageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.readmeBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.readmeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCodeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.spdxLicenseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)((Object)obj);
        return Objects.equals(this.author(), other.author()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.homePageUrl(), other.homePageUrl()) && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.licenseBody(), other.licenseBody()) && Objects.equals(this.licenseUrl(), other.licenseUrl()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.readmeBody(), other.readmeBody()) && Objects.equals(this.readmeUrl(), other.readmeUrl()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && Objects.equals(this.sourceCodeUrl(), other.sourceCodeUrl()) && Objects.equals(this.spdxLicenseId(), other.spdxLicenseId()) && Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.templateUrl(), other.templateUrl());
    }

    public String toString() {
        return ToString.builder((String)"CreateApplicationRequest").add("Author", (Object)this.author()).add("Description", (Object)this.description()).add("HomePageUrl", (Object)this.homePageUrl()).add("Labels", this.labels()).add("LicenseBody", (Object)this.licenseBody()).add("LicenseUrl", (Object)this.licenseUrl()).add("Name", (Object)this.name()).add("ReadmeBody", (Object)this.readmeBody()).add("ReadmeUrl", (Object)this.readmeUrl()).add("SemanticVersion", (Object)this.semanticVersion()).add("SourceCodeUrl", (Object)this.sourceCodeUrl()).add("SpdxLicenseId", (Object)this.spdxLicenseId()).add("TemplateBody", (Object)this.templateBody()).add("TemplateUrl", (Object)this.templateUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Author": {
                return Optional.ofNullable(clazz.cast(this.author()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HomePageUrl": {
                return Optional.ofNullable(clazz.cast(this.homePageUrl()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "LicenseBody": {
                return Optional.ofNullable(clazz.cast(this.licenseBody()));
            }
            case "LicenseUrl": {
                return Optional.ofNullable(clazz.cast(this.licenseUrl()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ReadmeBody": {
                return Optional.ofNullable(clazz.cast(this.readmeBody()));
            }
            case "ReadmeUrl": {
                return Optional.ofNullable(clazz.cast(this.readmeUrl()));
            }
            case "SemanticVersion": {
                return Optional.ofNullable(clazz.cast(this.semanticVersion()));
            }
            case "SourceCodeUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceCodeUrl()));
            }
            case "SpdxLicenseId": {
                return Optional.ofNullable(clazz.cast(this.spdxLicenseId()));
            }
            case "TemplateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "TemplateUrl": {
                return Optional.ofNullable(clazz.cast(this.templateUrl()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryRequest.BuilderImpl
    implements Builder {
        private String author;
        private String description;
        private String homePageUrl;
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();
        private String licenseBody;
        private String licenseUrl;
        private String name;
        private String readmeBody;
        private String readmeUrl;
        private String semanticVersion;
        private String sourceCodeUrl;
        private String spdxLicenseId;
        private String templateBody;
        private String templateUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            this.author(model.author);
            this.description(model.description);
            this.homePageUrl(model.homePageUrl);
            this.labels(model.labels);
            this.licenseBody(model.licenseBody);
            this.licenseUrl(model.licenseUrl);
            this.name(model.name);
            this.readmeBody(model.readmeBody);
            this.readmeUrl(model.readmeUrl);
            this.semanticVersion(model.semanticVersion);
            this.sourceCodeUrl(model.sourceCodeUrl);
            this.spdxLicenseId(model.spdxLicenseId);
            this.templateBody(model.templateBody);
            this.templateUrl(model.templateUrl);
        }

        public final String getAuthor() {
            return this.author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getHomePageUrl() {
            return this.homePageUrl;
        }

        @Override
        public final Builder homePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
            return this;
        }

        public final void setHomePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
        }

        public final Collection<String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
        }

        public final String getLicenseBody() {
            return this.licenseBody;
        }

        @Override
        public final Builder licenseBody(String licenseBody) {
            this.licenseBody = licenseBody;
            return this;
        }

        public final void setLicenseBody(String licenseBody) {
            this.licenseBody = licenseBody;
        }

        public final String getLicenseUrl() {
            return this.licenseUrl;
        }

        @Override
        public final Builder licenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
            return this;
        }

        public final void setLicenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getReadmeBody() {
            return this.readmeBody;
        }

        @Override
        public final Builder readmeBody(String readmeBody) {
            this.readmeBody = readmeBody;
            return this;
        }

        public final void setReadmeBody(String readmeBody) {
            this.readmeBody = readmeBody;
        }

        public final String getReadmeUrl() {
            return this.readmeUrl;
        }

        @Override
        public final Builder readmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
            return this;
        }

        public final void setReadmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getSourceCodeUrl() {
            return this.sourceCodeUrl;
        }

        @Override
        public final Builder sourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
            return this;
        }

        public final void setSourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
        }

        public final String getSpdxLicenseId() {
            return this.spdxLicenseId;
        }

        @Override
        public final Builder spdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
            return this;
        }

        public final void setSpdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateUrl() {
            return this.templateUrl;
        }

        @Override
        public final Builder templateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
            return this;
        }

        public final void setTemplateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryRequest.Builder,
    CopyableBuilder<Builder, CreateApplicationRequest> {
        public Builder author(String var1);

        public Builder description(String var1);

        public Builder homePageUrl(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder licenseBody(String var1);

        public Builder licenseUrl(String var1);

        public Builder name(String var1);

        public Builder readmeBody(String var1);

        public Builder readmeUrl(String var1);

        public Builder semanticVersion(String var1);

        public Builder sourceCodeUrl(String var1);

        public Builder spdxLicenseId(String var1);

        public Builder templateBody(String var1);

        public Builder templateUrl(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

