/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.AccountSources;
import software.amazon.awssdk.services.securitylake.model.AccountSourcesListCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDatalakeStatusResponse
extends SecurityLakeResponse
implements ToCopyableBuilder<Builder, GetDatalakeStatusResponse> {
    private static final SdkField<List<AccountSources>> ACCOUNT_SOURCES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountSourcesList").getter(GetDatalakeStatusResponse.getter(GetDatalakeStatusResponse::accountSourcesList)).setter(GetDatalakeStatusResponse.setter(Builder::accountSourcesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountSourcesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountSources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetDatalakeStatusResponse.getter(GetDatalakeStatusResponse::nextToken)).setter(GetDatalakeStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SOURCES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<AccountSources> accountSourcesList;
    private final String nextToken;

    private GetDatalakeStatusResponse(BuilderImpl builder) {
        super(builder);
        this.accountSourcesList = builder.accountSourcesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccountSourcesList() {
        return this.accountSourcesList != null && !(this.accountSourcesList instanceof SdkAutoConstructList);
    }

    public final List<AccountSources> accountSourcesList() {
        return this.accountSourcesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountSourcesList() ? this.accountSourcesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatalakeStatusResponse)) {
            return false;
        }
        GetDatalakeStatusResponse other = (GetDatalakeStatusResponse)((Object)obj);
        return this.hasAccountSourcesList() == other.hasAccountSourcesList() && Objects.equals(this.accountSourcesList(), other.accountSourcesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetDatalakeStatusResponse").add("AccountSourcesList", this.hasAccountSourcesList() ? this.accountSourcesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountSourcesList": {
                return Optional.ofNullable(clazz.cast(this.accountSourcesList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDatalakeStatusResponse, T> g) {
        return obj -> g.apply((GetDatalakeStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeResponse.BuilderImpl
    implements Builder {
        private List<AccountSources> accountSourcesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatalakeStatusResponse model) {
            super(model);
            this.accountSourcesList(model.accountSourcesList);
            this.nextToken(model.nextToken);
        }

        public final List<AccountSources.Builder> getAccountSourcesList() {
            List<AccountSources.Builder> result = AccountSourcesListCopier.copyToBuilder(this.accountSourcesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountSourcesList(Collection<AccountSources.BuilderImpl> accountSourcesList) {
            this.accountSourcesList = AccountSourcesListCopier.copyFromBuilder(accountSourcesList);
        }

        @Override
        public final Builder accountSourcesList(Collection<AccountSources> accountSourcesList) {
            this.accountSourcesList = AccountSourcesListCopier.copy(accountSourcesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountSourcesList(AccountSources ... accountSourcesList) {
            this.accountSourcesList(Arrays.asList(accountSourcesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountSourcesList(Consumer<AccountSources.Builder> ... accountSourcesList) {
            this.accountSourcesList(Stream.of(accountSourcesList).map(c -> (AccountSources)((AccountSources.Builder)AccountSources.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetDatalakeStatusResponse build() {
            return new GetDatalakeStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDatalakeStatusResponse> {
        public Builder accountSourcesList(Collection<AccountSources> var1);

        public Builder accountSourcesList(AccountSources ... var1);

        public Builder accountSourcesList(Consumer<AccountSources.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

